/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog;

import org.maru.dog.declare.BindPointDeclarator;
import org.maru.dog.declare.BoundPointDeclarator;
import org.maru.dog.declare.BindingDeclarator;
import org.maru.dog.declare.BridgeBindingDeclarator;
import org.maru.dog.declare.ConverterFlagDeclarator;
import org.maru.dog.declare.DeclarativeBindingDeclarator;

public abstract class Config {

    BindingDeclarator bindingDeclarator;

    private boolean isMaked = false;

    public synchronized void make() {
        if (isMaked == true) {
            return;
        }
        try {
            bindingDeclarator = new BindingDeclarator();
            define();
            isMaked = true;
        } catch (RuntimeException e) {
            bindingDeclarator = null;
            isMaked = false;
            throw e;
        }
    }
    protected abstract void define();

    protected BoundPointDeclarator declareFor(Class<?> target) {
        return bindingDeclarator.declareFor(target);
    }

    protected BoundPointDeclarator declareFor(Class<?> target, BindMode bindMode) {
        return bindingDeclarator.declareFor(target, bindMode);
    }

    protected BridgeBindingDeclarator bound(String name) {
        return bindingDeclarator.bound(name);
    }

    protected BindPointDeclarator from(Class<?> fromClass) {
        return bindingDeclarator.from(fromClass);
    }

    protected ConverterFlagDeclarator bind(String name) {
        return bindingDeclarator.bind(name);
    }

    public BoundPointDeclarator converterOff() {
        return bindingDeclarator.converterOff();
    }

    public DeclarativeBindingDeclarator end() {
        return bindingDeclarator.end();
    }

    public BindingDeclarator getBindingDeclarator() {
        return bindingDeclarator;
    }
}
