/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.maru.common.type.GenericClassType;
import org.maru.common.type.PrimitiveWrapperTypes;
import org.maru.common.util.ConditionUtil;
import org.maru.dog.bind.InputMarkedPoint;
import org.maru.dog.bind.TargetMarkedPoint;
import org.maru.dog.core.MarkedPoint;

public final class TypeSafeChecker {
    private TypeSafeChecker() {
    }

    public static void verifyTypeSafe(InputMarkedPoint<?> inputMarkedPoint, TargetMarkedPoint<?> targetMarkedPoint) {
        if (ConditionUtil.isNotNull(inputMarkedPoint.getConverterDef().converterClass)) {
            TypeSafeChecker.verifyTypeSafeWithConverter(inputMarkedPoint, targetMarkedPoint);
        } else {
            TypeSafeChecker.verifyTypeSafeWithNoConverter(inputMarkedPoint, targetMarkedPoint);
        }
    }

    private static void verifyTypeSafeWithConverter(InputMarkedPoint<?> inputMarkedPoint, TargetMarkedPoint<?> targetMarkedPoint) {
        GenericClassType inputType = TypeSafeChecker.getInputGenericClassType(inputMarkedPoint);
        Type convertedValueType = inputMarkedPoint.getConverterDef().convertedValueType;
        GenericClassType parameter = GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)convertedValueType) ? PrimitiveWrapperTypes.getWrapperType((Type)convertedValueType) : convertedValueType));
        Type returnValueType = inputMarkedPoint.getConverterDef().converterMethod.getGenericReturnType();
        GenericClassType returnType = GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)returnValueType) ? PrimitiveWrapperTypes.getWrapperType((Type)returnValueType) : returnValueType));
        GenericClassType targetType = TypeSafeChecker.getTargetGenericClassType(targetMarkedPoint);
        TypeSafeChecker.checkTypeSafe(inputType, parameter, returnType, targetType);
    }

    private static void verifyTypeSafeWithNoConverter(InputMarkedPoint<?> inputMarkedPoint, TargetMarkedPoint<?> targetMarkedPoint) {
        GenericClassType inputType = TypeSafeChecker.getInputGenericClassType(inputMarkedPoint);
        GenericClassType targetType = TypeSafeChecker.getTargetGenericClassType(targetMarkedPoint);
        TypeSafeChecker.checkTypeSafe(inputType, targetType);
    }

    private static GenericClassType getInputGenericClassType(MarkedPoint<?> markedPoint) {
        Method method;
        Field field;
        Type type;
        GenericClassType genericClassType = markedPoint.getMember() instanceof Field ? GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)(type = (field = (Field)markedPoint.getMember()).getGenericType())) ? PrimitiveWrapperTypes.getWrapperType((Type)type) : type)) : GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)(type = (method = (Method)markedPoint.getMember()).getGenericReturnType())) ? PrimitiveWrapperTypes.getWrapperType((Type)type) : type));
        return genericClassType;
    }

    private static GenericClassType getTargetGenericClassType(MarkedPoint<?> markedPoint) {
        Method method;
        Field field;
        Type type;
        GenericClassType genericClassType = markedPoint.getMember() instanceof Field ? GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)(type = (field = (Field)markedPoint.getMember()).getGenericType())) ? PrimitiveWrapperTypes.getWrapperType((Type)type) : type)) : GenericClassType.getGenericClassType((Type)(PrimitiveWrapperTypes.isPrimitiveType((Type)(type = (method = (Method)markedPoint.getMember()).getGenericParameterTypes()[0])) ? PrimitiveWrapperTypes.getWrapperType((Type)type) : type));
        return genericClassType;
    }

    private static void checkTypeSafe(GenericClassType inputType, GenericClassType parameter, GenericClassType returnType, GenericClassType targetType) {
        if (!inputType.equals((Object)parameter) || !targetType.equals((Object)returnType)) {
            throw new IllegalArgumentException("The inpout type [" + inputType.getType() + "] and the parameter type on converter method [" + parameter.getType() + "], the target type [" + targetType.getType() + "] and the return type on converter method [" + returnType.getType() + "] are not type safe.");
        }
    }

    private static void checkTypeSafe(GenericClassType inputType, GenericClassType targetType) {
        if (!inputType.equals((Object)targetType)) {
            throw new IllegalArgumentException("The input type [" + inputType.getType() + " and the target type [" + targetType.getType() + "] are not type safe.");
        }
    }
}

