/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.util.concurrent.ConcurrentMap;
import org.maru.common.Key;
import org.maru.common.MapFactory;

public class ConverterCache {
    private static final ConcurrentMap<Key<?>, Object> CACHED_CONVERTERS = MapFactory.createConcurrentSoftMap();

    private ConverterCache() {
    }

    public static Object apply(Key<?> key, Object value) {
        return CACHED_CONVERTERS.putIfAbsent(key, value);
    }

    public static Object get(Key<?> key) {
        return CACHED_CONVERTERS.get(key);
    }

    public static boolean containsKey(Key<?> key) {
        return CACHED_CONVERTERS.containsKey(key);
    }

    public static void clear() {
        CACHED_CONVERTERS.clear();
    }

    public static Object remove(Key<?> key) {
        return CACHED_CONVERTERS.remove(key);
    }
}

