/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.maru.common.Key;
import org.maru.common.KeyGen;
import org.maru.common.type.PrimitiveWrapperTypes;
import org.maru.common.util.ConditionUtil;
import org.maru.dog.bind.AccessorMethodBinder;
import org.maru.dog.bind.BindingConfiguration;
import org.maru.dog.bind.BindingContext;
import org.maru.dog.bind.BindingDefinition;
import org.maru.dog.bind.FieldBinder;
import org.maru.dog.bind.InputMarkedPoint;
import org.maru.dog.bind.InstanceBinder;
import org.maru.dog.bind.MemberBinder;
import org.maru.dog.bind.TargetMarkedPoint;
import org.maru.dog.bind.TypeSafeChecker;
import org.maru.dog.core.Builder;
import org.maru.dog.core.Configuration;
import org.maru.dog.core.Definition;
import org.maru.dog.core.MarkedPoint;

public abstract class AbstractBinderBuilder<T, K>
implements Builder {
    protected final T target;
    protected final K[] inputs;
    protected final InstanceBinder<T, K> instanceBinder;
    protected final List<Configuration> configurations;

    public AbstractBinderBuilder(List<Configuration> configurations, InstanceBinder<T, K> instanceBinder, T target, K ... inputs) {
        this.configurations = configurations;
        this.target = target;
        this.inputs = inputs;
        this.instanceBinder = instanceBinder;
    }

    public InstanceBinder<T, K> getInstanceBinder() {
        return this.instanceBinder;
    }

    @Override
    public Builder build() {
        Map<Key<?>, Definition<K>> inputDefinitions = this.buildInputMarkedPoints();
        Definition<T> targetDefinition = this.buildTargetMarkedPoints();
        this.validateAndCreateInstanceBinder(targetDefinition, inputDefinitions);
        return this;
    }

    protected Map<Key<?>, Definition<K>> buildInputMarkedPoints() {
        HashMap definitions = new HashMap();
        for (K input : this.inputs) {
            Class<?> inputClass = input.getClass();
            if (PrimitiveWrapperTypes.isPrimitiveOrWrapperType(inputClass)) continue;
            Key key = KeyGen.getKey(inputClass);
            Definition<?> definition = this.createAndStoreInputDefinition(key, inputClass);
            if (definitions.containsKey(key)) continue;
            definitions.put(key, definition);
        }
        return definitions;
    }

    protected Definition<T> buildTargetMarkedPoints() {
        Key key = KeyGen.getKey(this.target.getClass());
        Class<?> targetType = this.target.getClass();
        return this.createAndStoreTargetDefinition(key, targetType);
    }

    protected void validateAndCreateInstanceBinder(Definition<T> targetDefinition, Map<Key<?>, Definition<K>> inputDefinitions) {
        Key targetTypeKey = KeyGen.getKey(targetDefinition.getType());
        for (Map.Entry entry : ((BindingDefinition)targetDefinition).getMarkedPoints().entrySet()) {
            Key targetBoundKey = entry.getKey();
            TargetMarkedPoint targetMarkedPoint = (TargetMarkedPoint)entry.getValue();
            Class<?> inputClass = null;
            BindingConfiguration bindingConfiguration = this.searchBindingConfiguration(targetTypeKey, targetBoundKey);
            if (ConditionUtil.isNotNull((Object)bindingConfiguration)) {
                inputClass = bindingConfiguration.getInputClass();
                Key bindKey = ConditionUtil.isNotNull((Object)bindingConfiguration.getBindName()) ? KeyGen.getKey((Object)bindingConfiguration.getBindName()) : targetBoundKey;
                BindingContext<T, K> context = AbstractBinderBuilder.createBindingContext(targetMarkedPoint, bindKey, inputDefinitions, inputClass, bindingConfiguration);
                if (!ConditionUtil.isNotNull(context)) continue;
                MemberBinder<T, K> memberBinder = AbstractBinderBuilder.createMemberBinder(context);
                this.instanceBinder.addMemberBinder(memberBinder);
                continue;
            }
            inputClass = targetMarkedPoint.getInputClass();
            BindingContext<T, K> context = AbstractBinderBuilder.createBindingContext(targetMarkedPoint, targetBoundKey, inputDefinitions, inputClass, null);
            if (!ConditionUtil.isNotNull(context)) continue;
            MemberBinder<T, K> memberBinder = AbstractBinderBuilder.createMemberBinder(context);
            this.instanceBinder.addMemberBinder(memberBinder);
        }
    }

    private BindingConfiguration searchBindingConfiguration(Key<?> targetTypeKey, Key<?> targetBoundKey) {
        BindingConfiguration configuration = null;
        if (ConditionUtil.isNotNull(this.configurations) && this.configurations.size() > 0) {
            for (Configuration c : this.configurations) {
                Key configKey = KeyGen.getKey((Object)((BindingConfiguration)c).getBoundName());
                if (!targetBoundKey.equals((Object)configKey)) continue;
                configuration = (BindingConfiguration)c;
                break;
            }
        }
        return configuration;
    }

    protected abstract Definition<K> createAndStoreInputDefinition(Key<?> var1, Class<K> var2);

    protected abstract Definition<T> createAndStoreTargetDefinition(Key<?> var1, Class<T> var2);

    protected static <T, K> BindingContext<T, K> createBindingContext(TargetMarkedPoint<T> targetMarkedPoint, Key<?> targetBoundKey, Map<Key<?>, Definition<K>> inputDefinitions, Class<?> inputClass, BindingConfiguration configuration) {
        BindingContext bindingContext = null;
        if (ConditionUtil.isNotNull(inputClass)) {
            Definition<K> inputDefinition;
            Key inputClassKey = KeyGen.getKey(inputClass);
            if (inputDefinitions.containsKey(inputClassKey) && ((BindingDefinition)(inputDefinition = inputDefinitions.get(inputClassKey))).containsMarkedPoint(targetBoundKey)) {
                InputMarkedPoint inputMarkedPoint = (InputMarkedPoint)((BindingDefinition)inputDefinition).getMarkedPoint(targetBoundKey);
                TypeSafeChecker.verifyTypeSafe(inputMarkedPoint, targetMarkedPoint);
                bindingContext = new BindingContext(targetMarkedPoint, inputMarkedPoint, configuration);
            }
        } else {
            int duplicateCount = 0;
            MarkedPoint inputMarkedPoint = null;
            for (Map.Entry<Key<?>, Definition<K>> inputEntry : inputDefinitions.entrySet()) {
                for (Map.Entry definedEntry : ((BindingDefinition)inputEntry.getValue()).getMarkedPoints().entrySet()) {
                    InputMarkedPoint tmpInputMarkedPoint = (InputMarkedPoint)definedEntry.getValue();
                    if (!tmpInputMarkedPoint.getName().equals(targetMarkedPoint.getName())) continue;
                    if (duplicateCount == 0) {
                        inputMarkedPoint = tmpInputMarkedPoint;
                    }
                    ++duplicateCount;
                }
            }
            if (duplicateCount > 1) {
                throw new IllegalArgumentException("The name [" + inputMarkedPoint.getName() + "] is duplicate.");
            }
            if (duplicateCount == 1) {
                TypeSafeChecker.verifyTypeSafe(inputMarkedPoint, targetMarkedPoint);
                bindingContext = new BindingContext(targetMarkedPoint, inputMarkedPoint, configuration);
            }
        }
        return bindingContext;
    }

    protected static <T, K> MemberBinder<T, K> createMemberBinder(BindingContext<T, K> context) {
        Member member = context.getTargetMarkedPoint().getMember();
        if (member instanceof Field) {
            return new FieldBinder<T, K>(context);
        }
        if (member instanceof Method) {
            return new AccessorMethodBinder<T, K>(context);
        }
        throw new IllegalArgumentException("Fails to solve the field or method binder.");
    }

    public T getTargetInstance() {
        return this.target;
    }

    public K[] getInputInstances() {
        return this.inputs;
    }
}

