/*
 * Decompiled with CFR 0.152.
 */
package org.maru.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Clazz {
    private Clazz() {
    }

    public static <T> Constructor<?> getDefaultConstructor(Class<T> type) {
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            if (constructor.getGenericParameterTypes().length != 0) continue;
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        return null;
    }

    public static <T> boolean isAbstractClass(Class<T> type) {
        return Modifier.isAbstract(type.getModifiers());
    }

    public static <T> boolean isInterface(Class<T> type) {
        return Modifier.isInterface(type.getModifiers());
    }

    public static <A> boolean isAnnotationClass(Class<? extends A> type) {
        return type.isAnnotation();
    }

    public static <T> boolean isArray(Class<T> type) {
        return type.isArray();
    }

    public static <T> boolean isClassType(T type) {
        return type instanceof Class;
    }

    public static <A> boolean isAnnotation(A type) {
        return type instanceof Annotation;
    }

    public static Method getDeclaredMethod(Class<?> target, String name, Class<?> ... parameterTypes) {
        try {
            return target.getDeclaredMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

