/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.pref;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/**
 *
 * @author NAKAZATO Hajime
 */
class LocalImpl extends ClientPreference {

    private static final int pieceLength = (Preferences.MAX_VALUE_LENGTH * 3) / 4;
    private static final String LENGTH_KEY = "length";
    private final Preferences prefs;

    LocalImpl(String address, String path) {
        prefs = Preferences.userNodeForPackage(LocalImpl.class).node(address).node(path);
    }

    private byte[] object2Bytes(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        return baos.toByteArray();
    }

    private Object bytes2Object(byte raw[]) throws IOException,
            ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(raw);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        return o;
    }

    private byte[][] breakIntoPieces(byte raw[]) {
        int numPieces = (raw.length + pieceLength - 1) / pieceLength;
        byte pieces[][] = new byte[numPieces][];
        for (int i = 0; i < numPieces; ++i) {
            int startByte = i * pieceLength;
            int endByte = startByte + pieceLength;
            if (endByte > raw.length) {
                endByte = raw.length;
            }
            int length = endByte - startByte;
            pieces[i] = new byte[length];
            System.arraycopy(raw, startByte, pieces[i], 0, length);
        }
        return pieces;
    }

    private byte[] combinePieces(byte pieces[][]) {
        int length = 0;
        for (int i = 0; i < pieces.length; ++i) {
            length += pieces[i].length;
        }
        byte raw[] = new byte[length];
        int cursor = 0;
        for (int i = 0; i < pieces.length; i++) {
            System.arraycopy(pieces[i], 0, raw, cursor, pieces[i].length);
            cursor += pieces[i].length;
        }
        return raw;
    }

    private void writePieces(String key, byte pieces[][]) {
        Preferences child = prefs.node(key);
        for (int i = 0; i < pieces.length; i++) {
            child.putByteArray(Integer.toString(i), pieces[i]);
        }
        child.putInt(LENGTH_KEY, pieces.length);
    }

    private void putObject(String key, Object o) throws IOException,
            BackingStoreException, ClassNotFoundException {
        byte raw[] = object2Bytes(o);
        byte pieces[][] = breakIntoPieces(raw);
        writePieces(key, pieces);
    }

    private byte[][] readPieces(String key) {
        Preferences child = prefs.node(key);
        int numPieces = child.getInt(LENGTH_KEY, 0);
        if (numPieces == 0) {
            return null;
        }
        byte pieces[][] = new byte[numPieces][0];
        for (int i = 0; i < numPieces; i++) {
            pieces[i] = child.getByteArray(Integer.toString(i), null);
        }
        return pieces;
    }

    private Object getObject(String key) throws IOException,
            BackingStoreException, ClassNotFoundException {
        byte pieces[][] = readPieces(key);
        if (pieces == null) {
            return null;
        }
        byte raw[] = combinePieces(pieces);
        Object o = bytes2Object(raw);
        return o;
    }

    @Override
    public Object deserialize(String key) {
        try {
            return getObject(key);
        } catch (BackingStoreException e) {
            return null;
        } catch (ClassNotFoundException e) {
            try {
                removeAll();
            } catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            return null;
        } catch (IOException e) {
            try {
                removeAll();
            } catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            return null;
        }
    }

    @Override
    public void serialize(String key, Serializable obj) throws IOException {
        try {
            if (obj == null) {
                prefs.node(key).removeNode();
            } else {
                putObject(key, obj);
            }
            prefs.flush();
        } catch (BackingStoreException e) {
            throw new IOException(e);
        } catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserialize(String key, Object alt) {
        Object o = deserialize(key);
        if (o == null) {
            return alt;
        }
        return o;
    }

    @Override
    public void removeAll() throws IOException {
        try {
            prefs.removeNode();
        } catch (BackingStoreException e) {
            throw new IOException(e);
        }
    }
}
