/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.pref;

import java.io.IOException;
import java.io.Serializable;

/**
 *
 * @author NAKAZATO Hajime
 */
public abstract class ClientPreference {

    protected ClientPreference() {
    }

    abstract public void serialize(String key, Serializable obj) throws IOException;

    abstract public Object deserialize(String key);

    abstract public Object deserialize(String key, Object alt);

    abstract public void removeAll() throws IOException;

    public static ClientPreference getInstance(String address, String path) {
        ClientPreference cp;
        try {
            cp = new JnlpImpl(path);
        } catch (Throwable t) {
            cp = new LocalImpl(address, path);
        }
        return cp;
    }
}
