/*
 * DnDableTabDialog.java
 *
 * Created on 2008/03/26, 16:56
 */
package org.kaoriha.marimite.viewer.dnd;

import java.awt.HeadlessException;
import java.awt.Window;
import org.kaoriha.marimite.viewer.pref.WindowLocator;
import org.kaoriha.marimite.viewer.dnd.PanePacker;

/**
 *
 * @author  NAKAZATO Hajime
 */
public class DnDableTabDialog extends javax.swing.JDialog {

    private static String TITLE;
    private WindowLocator windowLocator;
    private PanePacker panePacker;

    public static void init(String title) {
        TITLE = title;
    }

    /** Creates new form DnDableTabDialog */
    public DnDableTabDialog(Window owner, String key)
            throws HeadlessException {
        super(owner);

        initComponents();

        panePacker = new PanePacker(key, getTabbedPane());
        windowLocator = new WindowLocator(key, this);
        setTitle(TITLE);
    }

    @Override
    public void dispose() {
        panePacker.dispose();
        windowLocator.dispose();
        ((DnDableTabbedPane) tabbedPane).dispose();
        super.dispose();
    }

    public DnDableTabbedPane getTabbedPane() {
        return (DnDableTabbedPane) tabbedPane;
    }
    
    /** This method is called from within the constructor to
     * startDnDableTabDialog the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        tabbedPane = new DnDableTabbedPane(this);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(tabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(tabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTabbedPane tabbedPane;
    // End of variables declaration//GEN-END:variables
}
