/*
 * RootFrame.java
 *
 * Created on 2008/03/28, 23:09
 */
package org.kaoriha.marimite.viewer;

import java.util.Timer;
import java.util.TimerTask;
import org.kaoriha.marimite.viewer.chart.Updater;
import org.kaoriha.marimite.viewer.dnd.PanePacker;
import org.kaoriha.marimite.viewer.pref.WindowLocator;

/**
 *
 * @author  NAKAZATO Hajime
 */
public class RootFrame extends javax.swing.JFrame {

    private Timer refreshTimer = null;
    private long currentRefreshInterval;

    private static class RefreshRunner extends TimerTask {

        @Override
        public void run() {
            Updater.updateAll();
        }
    }

    /** Creates new form RootFrame */
    public RootFrame() {
        initComponents();
        refreshIntervalComboBox.setSelectedIndex(1);
        setConnectionStatus(MessageResource.ConnectionStatus.NOT_YET_OPEN);
        connectAddressTextField.setText(Main.getServerAddress() + "/" + Main.getJndiName());
        mbeanDomainTextField.setText(Main.getJmxDomainName());
        setTitle(MessageResource.TitleBar.getRootFrame());
        new WindowLocator("RootFrame", this);
    }

    private void changeRefreshInterval() {
        int selected = refreshIntervalComboBox.getSelectedIndex();
        long interval;
        switch (selected) {
            case 0:
                interval = 300;
                break;
            case 1:
                interval = 1000;
                break;
            case 2:
                interval = 3000;
                break;
            case 3:
                interval = 10000;
                break;
            case 4:
                refreshTimer.cancel();
                currentRefreshInterval = 0;
                return;
            default:
                return;
        }
        if (interval == currentRefreshInterval) {
            return;
        }
        if (refreshTimer != null) {
            refreshTimer.cancel();
        }
        refreshTimer = new Timer();
        refreshTimer.schedule(new RefreshRunner(),
                interval, interval);
        currentRefreshInterval = interval;
    }

    /** This method is called from within the constructor to
     * startDnDableTabDialog the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        connectAddressTextField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        refreshIntervalComboBox = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        connectionStatusTextField = new javax.swing.JTextField();
        showChartButton = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        mbeanDomainTextField = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        connectAddressTextField.setEditable(false);
        connectAddressTextField.setText("connectAddressTextField");

        jLabel1.setText("接続先");

        jLabel2.setText("更新間隔");

        refreshIntervalComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "0.3 sec", "1 sec", "3 sec", "10 sec", "Stop" }));
        refreshIntervalComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                refreshIntervalComboBoxItemStateChanged(evt);
            }
        });

        jLabel3.setText("接続状態");

        connectionStatusTextField.setEditable(false);
        connectionStatusTextField.setText("connectionStatusTextField");

        showChartButton.setText("未表示チャートを表示");
        showChartButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showChartButtonActionPerformed(evt);
            }
        });

        jLabel5.setText("MBeanドメイン名");

        mbeanDomainTextField.setEditable(false);
        mbeanDomainTextField.setText("mbeanDomainTextField");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(connectAddressTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 322, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(mbeanDomainTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(connectionStatusTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(refreshIntervalComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 63, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 110, Short.MAX_VALUE)
                        .addComponent(showChartButton)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(connectAddressTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(mbeanDomainTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(connectionStatusTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(10, 10, 10)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(refreshIntervalComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(showChartButton)
                    .addComponent(jLabel2))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void refreshIntervalComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_refreshIntervalComboBoxItemStateChanged
        changeRefreshInterval();
    }//GEN-LAST:event_refreshIntervalComboBoxItemStateChanged

    private void showChartButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showChartButtonActionPerformed
        new LimitDialog(this).setVisible(true);
    }//GEN-LAST:event_showChartButtonActionPerformed

    @Override
    public void dispose() {
        refreshTimer.cancel();
        PanePacker.suspend();
        WindowLocator.shutdown();
        super.dispose();
        System.exit(0);
    }

    public void setConnectionStatus(String connectionStatus) {
        connectionStatusTextField.setText(connectionStatus);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField connectAddressTextField;
    private javax.swing.JTextField connectionStatusTextField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JTextField mbeanDomainTextField;
    private javax.swing.JComboBox refreshIntervalComboBox;
    private javax.swing.JButton showChartButton;
    // End of variables declaration//GEN-END:variables
}
