/*
 * LimitDialog.java
 *
 * Created on 2008/04/06, 20:20
 */
package org.kaoriha.marimite.viewer;

import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.management.InstanceNotFoundException;
import javax.management.ReflectionException;
import javax.swing.JOptionPane;
import org.kaoriha.marimite.viewer.chart.ChartUtil;
import org.kaoriha.marimite.viewer.jmx.JmxRemote;
import org.kaoriha.marimite.viewer.chart.Updater;
import org.kaoriha.marimite.viewer.dnd.DnDableTabDialog;

/**
 *
 * @author  NAKAZATO Hajime
 */
public class LimitDialog extends javax.swing.JDialog {

    private List<String> sectionList;
    private List<String> limitedSectionList;

    /** Creates new form LimitDialog */
    public LimitDialog(Window owner) {
        super(owner);

        initComponents();

        setLocationByPlatform(true);

        try {
            initSectionList();
        } catch (Exception e) {
            JmxRemote.notifyLostConnection();
            JOptionPane.showMessageDialog(this,
                    MessageResource.ErrorMessageDialog.NO_CONNECTION_MESSAGE,
                    MessageResource.ErrorMessageDialog.NO_CONNECTION_TITLE,
                    JOptionPane.ERROR_MESSAGE);
            dispose();
            return;
        }
        updateSectionList();
    }

    private void initSectionList() throws IOException, ReflectionException, InstanceNotFoundException {
        Set<String> sectionSet = new HashSet<String>();

        for (String s : JmxRemote.getLogSectionSet()) {
            sectionSet.add(s);
        }

        for (String s : JmxRemote.getLiveSectionSet()) {
            sectionSet.add(s);
        }
        sectionSet.removeAll(Updater.getAllViewingSectionSet());

        sectionList = new ArrayList<String>(sectionSet);
        Collections.sort(sectionList);
    }

    private void updateSectionList() {
        limitedSectionList = new ArrayList<String>();
        String cont = limitTextField.getText();
        if (cont.length() == 0) {
            limitedSectionList.addAll(sectionList);
        } else {
            for (String s : sectionList) {
                if (s.contains(cont)) {
                    limitedSectionList.add(s);
                }
            }
        }

        sectionJList.setModel(new javax.swing.AbstractListModel() {

            String[] strings = limitedSectionList.toArray(new String[0]);

            @Override
            public int getSize() {
                return strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return strings[i];
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        sectionJList = new javax.swing.JList();
        jLabel1 = new javax.swing.JLabel();
        limitTextField = new javax.swing.JTextField();
        viewButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("未表示のセクションを表示");

        sectionJList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        sectionJList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                sectionJListMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(sectionJList);

        jLabel1.setText("セクションに含まれる文字列");

        limitTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                limitTextFieldKeyTyped(evt);
            }
        });

        viewButton.setText("すべて表示");
        viewButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                viewButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(limitTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 242, Short.MAX_VALUE)
                        .addContainerGap())
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(viewButton)
                        .addContainerGap())))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(limitTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(viewButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 228, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void limitTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_limitTextFieldKeyTyped
        updateSectionList();
    }//GEN-LAST:event_limitTextFieldKeyTyped

    private void sectionJListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_sectionJListMouseClicked
        if (evt.getClickCount() != 2) {
            return;
        }
        int selected = sectionJList.locationToIndex(evt.getPoint());
        String s = limitedSectionList.get(selected);
        createDialog(s);
        sectionList.remove(s);
        updateSectionList();
    }//GEN-LAST:event_sectionJListMouseClicked

    private void viewButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_viewButtonActionPerformed
        while (!limitedSectionList.isEmpty()) {
            createDialog(limitedSectionList);
        }
        dispose();
    }//GEN-LAST:event_viewButtonActionPerformed

    private void createDialog(String section) {
        DnDableTabDialog f = new DnDableTabDialog(Main.getRootFrame(), UUID.randomUUID().toString());
        f.getTabbedPane().addTab(section, null, ChartUtil.getChartPanel(), null);
        f.setVisible(true);
    }

    private void createDialog(List<String> sectionList) {
        DnDableTabDialog f = new DnDableTabDialog(Main.getRootFrame(), UUID.randomUUID().toString());
        int i = 0;
        for (Iterator<String> iter = sectionList.iterator(); iter.hasNext();) {
            String s = iter.next();
            f.getTabbedPane().addTab(s, null, ChartUtil.getChartPanel(), null);
            iter.remove();
            i++;
            if (i > 3) {
                break;
            }
        }
        f.setVisible(true);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField limitTextField;
    private javax.swing.JList sectionJList;
    private javax.swing.JButton viewButton;
    // End of variables declaration//GEN-END:variables
}
