/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.kaoriha.marimite.viewer.Main;
import org.kaoriha.marimite.viewer.MessageResource;

/**
 *
 * @author NAKAZATO Hajime
 */
public class JmxRemote {

    private static final JmxRemote INSTANCE = new JmxRemote();
    public static final ObjectName MONITOR_LOG_OBJNAME;
    public static final ObjectName MONITOR_LIVE_OBJNAME;
    private static final JMXServiceURL SERVICE_URL;

    static {
        ObjectName n = null;
        ObjectName n2 = null;
        JMXServiceURL url = null;
        try {
            n = new ObjectName(Main.getJmxDomainName(), "monitor",
                    "log");
            n2 = new ObjectName(Main.getJmxDomainName(), "monitor",
                    "live");
            url = new JMXServiceURL(Main.getJmxServiceUrl());
        } catch (MalformedURLException e) {
            throw new RuntimeException(e);
        } catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        MONITOR_LOG_OBJNAME = n;
        MONITOR_LIVE_OBJNAME = n2;
        SERVICE_URL = url;
    }

    private MBeanServerConnection connection = null;
    private long lostDate = System.currentTimeMillis();

    private JmxRemote() {
    }

    private synchronized MBeanServerConnection getConnectionImpl() throws IOException {
        if (connection == null) {
            JMXConnector conn = JMXConnectorFactory.connect(SERVICE_URL, null);
            connection = conn.getMBeanServerConnection();
            Main.getRootFrame().setConnectionStatus(MessageResource.ConnectionStatus.OK);
        }
        return connection;
    }

    public static MBeanServerConnection getConnection() throws IOException {
        return INSTANCE.getConnectionImpl();
    }

    public static void notifyLostConnection() {
        synchronized (INSTANCE) {
            if (INSTANCE.connection != null) {
                INSTANCE.connection = null;
                INSTANCE.lostDate = System.currentTimeMillis();
            }
        }
        Main.getRootFrame().setConnectionStatus(MessageResource.ConnectionStatus.getError(INSTANCE.lostDate));
    }

    public static Set<String> getLogSectionSet() throws IOException, ReflectionException, InstanceNotFoundException {
        Set<String> sectionSet = new HashSet<String>();

        String[] arg = {"SectionList"};
        AttributeList attributeList = getConnection().getAttributes(JmxRemote.MONITOR_LOG_OBJNAME,
                arg);
        Attribute attribute = (Attribute) attributeList.get(0);
        String[] logSectionArray = (String[]) attribute.getValue();
        for (String s : logSectionArray) {
            sectionSet.add(s);
        }

        return sectionSet;
    }

    public static Set<String> getLiveSectionSet() throws IOException, ReflectionException, InstanceNotFoundException {
        Set<String> sectionSet = new HashSet<String>();

        String[] arg = {"SectionList"};
        AttributeList attributeList = getConnection().getAttributes(JmxRemote.MONITOR_LIVE_OBJNAME,
                arg);
        Attribute attribute = (Attribute) attributeList.get(0);
        String[] logSectionArray = (String[]) attribute.getValue();
        for (String s : logSectionArray) {
            sectionSet.add(s);
        }

        return sectionSet;
    }
}
