/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.kaoriha.marimite.viewer.Main;
import org.kaoriha.marimite.viewer.MessageResource;

public class JmxRemote {
    private static final JmxRemote INSTANCE = new JmxRemote();
    public static final ObjectName MONITOR_LOG_OBJNAME;
    public static final ObjectName MONITOR_LIVE_OBJNAME;
    private static final JMXServiceURL SERVICE_URL;
    private MBeanServerConnection connection = null;
    private long lostDate = System.currentTimeMillis();

    private JmxRemote() {
    }

    private synchronized MBeanServerConnection getConnectionImpl() throws IOException {
        if (this.connection == null) {
            JMXConnector conn = JMXConnectorFactory.connect(SERVICE_URL, null);
            this.connection = conn.getMBeanServerConnection();
            Main.getRootFrame().setConnectionStatus("\u6b63\u5e38\u306b\u63a5\u7d9a\u4e2d");
        }
        return this.connection;
    }

    public static MBeanServerConnection getConnection() throws IOException {
        return INSTANCE.getConnectionImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyLostConnection() {
        JmxRemote jmxRemote = INSTANCE;
        synchronized (jmxRemote) {
            if (JmxRemote.INSTANCE.connection != null) {
                JmxRemote.INSTANCE.connection = null;
                JmxRemote.INSTANCE.lostDate = System.currentTimeMillis();
            }
        }
        Main.getRootFrame().setConnectionStatus(MessageResource.ConnectionStatus.getError(JmxRemote.INSTANCE.lostDate));
    }

    static {
        ObjectName n = null;
        ObjectName n2 = null;
        JMXServiceURL url = null;
        try {
            n = new ObjectName(Main.getJmxDomainName(), "monitor", "log");
            n2 = new ObjectName(Main.getJmxDomainName(), "monitor", "live");
            url = new JMXServiceURL(Main.getJmxServiceUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        MONITOR_LOG_OBJNAME = n;
        MONITOR_LIVE_OBJNAME = n2;
        SERVICE_URL = url;
    }
}

