/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer.chart;

import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.kaoriha.marimite.viewer.ImageResource;
import org.kaoriha.marimite.viewer.MessageResource;
import org.kaoriha.marimite.viewer.chart.DateLogAxis;
import org.kaoriha.marimite.viewer.chart.ToolTipGenerator;
import org.kaoriha.marimite.viewer.dnd.DnDableTabbedPane;
import org.kaoriha.marimite.viewer.jmx.JmxRemote;

public class ChartUtil {
    public static ChartPanel getChartPanel() {
        XYIntervalSeriesCollection dataset = new XYIntervalSeriesCollection();
        DateLogAxis xAxis = new DateLogAxis();
        xAxis.setInverted(true);
        NumberAxis yAxis = new NumberAxis();
        DeviationRenderer renderer = new DeviationRenderer(true, true);
        renderer.setAlpha(0.2f);
        renderer.setSeriesPaint(0, (Paint)Color.BLUE);
        renderer.setSeriesPaint(1, (Paint)Color.RED);
        renderer.setSeriesPaint(2, (Paint)Color.GREEN);
        renderer.setSeriesFillPaint(0, renderer.getSeriesPaint(0));
        renderer.setSeriesFillPaint(1, renderer.getSeriesPaint(1));
        renderer.setSeriesFillPaint(2, renderer.getSeriesPaint(2));
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new ToolTipGenerator());
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        XYLineAndShapeRenderer sr = new XYLineAndShapeRenderer(false, true);
        sr.setSeriesPaint(0, (Paint)Color.YELLOW);
        plot.setRenderer(1, (XYItemRenderer)sr);
        plot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
        JFreeChart chart = new JFreeChart(null, UIManager.getFont("Label.font"), (Plot)plot, true);
        ChartPanel panel = new ChartPanel(chart);
        JPopupMenu pm = panel.getPopupMenu();
        pm.addSeparator();
        JMenuItem removeMenu = new JMenuItem("Remove");
        removeMenu.addActionListener(new RemoveListener(panel));
        pm.add(removeMenu);
        return panel;
    }

    private static class RemoveListener
    implements ActionListener {
        private ChartPanel panel;

        RemoveListener(ChartPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            block5: {
                DnDableTabbedPane tabbedPane = (DnDableTabbedPane)this.panel.getParent();
                if (tabbedPane.getSelectedIndex() == -1) {
                    return;
                }
                String section = tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
                int r = JOptionPane.showConfirmDialog(tabbedPane, MessageResource.ConfirmDialog.getRemoveSectionMessage(section), "\u30bb\u30af\u30b7\u30e7\u30f3\u306e\u524a\u9664 - Marimite", 2);
                if (r != 0) {
                    return;
                }
                try {
                    this.removeImpl(JmxRemote.getConnection(), tabbedPane);
                }
                catch (Exception e) {
                    JmxRemote.notifyLostConnection();
                    if (tabbedPane.getSelectedIndex() == -1) {
                        return;
                    }
                    Icon icon = ImageResource.getCrossIcon();
                    int index = tabbedPane.getSelectedIndex();
                    if (tabbedPane.getIconAt(index) == icon) break block5;
                    tabbedPane.setIconAt(index, icon);
                    tabbedPane.setToolTipTextAt(index, "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u63a5\u7d9a\u306b\u30a8\u30e9\u30fc");
                    tabbedPane.repaint();
                }
            }
        }

        private void removeImpl(MBeanServerConnection connection, DnDableTabbedPane tabbedPane) throws IOException, InstanceNotFoundException, MBeanException, ReflectionException {
            int selectedTabIdx = tabbedPane.getSelectedIndex();
            Object[] params = new Object[]{tabbedPane.getTitleAt(selectedTabIdx)};
            String[] signature = new String[]{"java.lang.String"};
            connection.invoke(JmxRemote.MONITOR_LIVE_OBJNAME, "removeSection", params, signature);
            connection.invoke(JmxRemote.MONITOR_LOG_OBJNAME, "removeSection", params, signature);
            tabbedPane.remove(selectedTabIdx);
            if (tabbedPane.getTabCount() == 0) {
                tabbedPane.getRootWindow().dispose();
            }
        }
    }
}

