package org.kaoriha.marimite;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class PerformanceSpecialTest {
	public static void main(String[] args) throws InterruptedException, ExecutionException {
		MarimiteConfig.start();
		Stopwatch.start("main start");
		long start = System.currentTimeMillis();
		ExecutorService es = Executors.newFixedThreadPool(10);
		Set<Future<?>> sf = new HashSet<Future<?>>();
		for (int i = 0; i < 10; i++) {
			sf.add(es.submit(new TestC()));
		}
		for (Future<?> f : sf) {
			f.get();
		}
		System.out.println(System.currentTimeMillis() - start);
		Stopwatch.lap("exit");
		es.shutdown();
		es.awaitTermination(1, TimeUnit.SECONDS);
		MarimiteConfig.stop();
	}

	private static class TestC implements Runnable {
		public void run() {
			Stopwatch.start("TestC start");
			for (int i = 0; i < 1000000; i++) {
				Stopwatch.lap("before");
				i ++;
				Stopwatch.lap("after");
			}
			Stopwatch.lap("exit");
		}
	}
}
