package org.kaoriha.marimite;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Random;

import junit.framework.Assert;
import junit.framework.TestCase;

public class StopwatchTest extends TestCase {
	private Random rnd = new Random();

	public void testSimple() throws Exception {
		MarimiteConfig.start();

		try {
			LocalStopwatch ls = new LocalStopwatch("StopwatchTest#testSimple enter");
			Stopwatch.start("start");

			TestC tc = new TestC();

			for (int i = 0; i < 501; i++) {
				tc.lap();
			}

			ls.lap("testSimple 1");

			Assert.assertEquals(4, Stopwatch.getSectionSet().length);
			/*
			 * for (String s : Stopwatch.getSectionSet()) { System.out.print(s + "
			 * :"); for (long t : Stopwatch.get(s)) { System.out.print("," + t); }
			 * System.out.println(); }
			 */
			Thread.sleep(100);

			Connection conn = MarimiteConfig.getConnection();
			ResultSet rs = conn.prepareStatement("select * from lap")
					.executeQuery();
			int count = 0;
			while (rs.next()) {
				count++;
				/*
				  System.out.println(rs.getLong("section_id") + ":" +
				  rs.getDouble("elapse_med") + ":" + rs.getDouble("elapse_tail") +
				  ":" + rs.getDouble("elapse_worst"));
				 */
			}
			Assert.assertEquals(9, count);

			rs.close();
			conn.close();
		} finally {
			TestUtil.cleanup();
			MarimiteConfig.stop();
		}
	}

	class TestC {
		public void lap() throws InterruptedException {
			Stopwatch.lap("lap in");
			Thread.sleep((long) (100L * rnd.nextDouble()));
			Stopwatch.lap("lap out");
		}
	}
}
