package org.kaoriha.marimite;

import java.util.Set;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class RemoteJmxConnectionSpecialTest {
	private MBeanServerConnection connection;

	public void test() throws Exception {
		JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost/marimite-testbench");
		JMXConnector connector = JMXConnectorFactory.connect(url, null);
		connection = connector.getMBeanServerConnection();

		ObjectName n = new ObjectName("org.kaoriha.marimite", "monitor",
				"live");
		Set<ObjectInstance> mbeans = connection.queryMBeans(n, null);

		for (ObjectInstance objInstance : mbeans) {
			System.out.println("Name: " + objInstance.getObjectName());
			System.out.println("Class: " + objInstance.getClassName());

			showMBeanInfo(objInstance.getObjectName());

			AttributeList attributeList = connection.getAttributes(n,
					"SectionList".split("XXX"));
			Attribute attribute = (Attribute) attributeList.get(0);
			String[] sectionList = (String[]) attribute.getValue();
			for (String s : sectionList) {
				System.out.println(s);
			}
			System.out.println();

			Object[] params = new Object[1];
			params[0] = sectionList[0];
			String[] signature = new String[1];
			signature[0] = "java.lang.String";
			Long[] lap = (Long[]) connection.invoke(n, "getLap", params, signature);
			for (long l : lap) {
				System.out.println(l);
			}
		}
		System.out.println();
	}

	private void showMBeanInfo(ObjectName name) throws Exception {
		MBeanInfo info = connection.getMBeanInfo(name);
		String description = info.getDescription();
		System.out.println("Description: " + description);

		showMBeanAttributeInfo(info);
		showMBeanOperationInfo(info);
	}

	private void showMBeanOperationInfo(MBeanInfo info) {
		MBeanOperationInfo[] operations = info.getOperations();

		if (operations.length > 0) {
			System.out.println("Operations:");

			for (MBeanOperationInfo operation : operations) {
				System.out.println("    Name: " + operation.getName());
				System.out.println("    Description: "
						+ operation.getDescription());
				System.out.println("    Signature: ");
				MBeanParameterInfo[] arguments = operation.getSignature();
				for (MBeanParameterInfo argument : arguments) {
					System.out.println("        Name: " + argument.getName()
							+ " Type: " + argument.getType());
				}
				System.out.println("    Return Type: "
						+ operation.getReturnType());
				System.out.println();
			}
		}
	}

	private void showMBeanAttributeInfo(MBeanInfo info) {
		MBeanAttributeInfo[] attributes = info.getAttributes();

		if (attributes.length > 0) {
			System.out.println("Attributes:");

			for (MBeanAttributeInfo attribute : attributes) {
				System.out.println("    Name: " + attribute.getName());
				System.out.println("    Description: "
						+ attribute.getDescription());
				System.out.println("    Type: " + attribute.getType());
				if (attribute.isReadable()) {
					if (attribute.isWritable()) {
						System.out.println("    Access: RW");
					} else {
						System.out.println("    Access: RO");
					}
				} else {
					if (attribute.isWritable()) {
						System.out.println("    Access: WO");
					}
				}
				System.out.println();
			}
		}
	}

	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {
		new RemoteJmxConnectionSpecialTest().test();
	}

}
