/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.kaoriha.marimite.LogJMXMBean;
import org.kaoriha.marimite.MarimiteConfig;
import org.kaoriha.marimite.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LogJMX
implements LogJMXMBean {
    LogJMX() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Double[]> getLog(String section) {
        Connection conn = null;
        try {
            Section s;
            conn = MarimiteConfig.getConnection();
            try {
                s = Section.fromString(section);
            }
            catch (IllegalArgumentException e) {
                Map<Long, Double[]> map = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                }
                return map;
            }
            Map<Long, Double[]> map = this.getLogImpl(conn, s);
            return map;
        }
        catch (SQLException e) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Double[]> getLogImpl(Connection conn, Section section) throws SQLException {
        PreparedStatement selLap = conn.prepareStatement("select id, section_id, elapse_med, elapse_med_var, elapse_tail, elapse_tail_var, elapse_worst, elapse_worst_var, sample_date, n_sample from lap where section_id = ?");
        long sectionId = section.getIdAsPersistent(conn);
        if (sectionId == -1L) {
            return null;
        }
        selLap.setLong(1, sectionId);
        IdentityHashMap<Long, Double[]> r = new IdentityHashMap<Long, Double[]>();
        ResultSet rs = null;
        try {
            rs = selLap.executeQuery();
            while (rs.next()) {
                Double[] d = new Double[]{rs.getDouble("elapse_med"), rs.getDouble("elapse_med_var"), rs.getDouble("elapse_tail"), rs.getDouble("elapse_tail_var"), rs.getDouble("elapse_worst"), rs.getDouble("elapse_worst_var")};
                Timestamp ts = rs.getTimestamp("sample_date");
                r.put(ts.getTime(), d);
            }
            IdentityHashMap<Long, Double[]> identityHashMap = r;
            return identityHashMap;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSectionList() {
        Connection conn = null;
        try {
            conn = MarimiteConfig.getConnection();
            String[] stringArray = this.getSectionListImpl(conn);
            return stringArray;
        }
        catch (SQLException e) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSectionListImpl(Connection conn) throws SQLException {
        ArrayList<String> r = new ArrayList<String>();
        PreparedStatement selSection = conn.prepareStatement("select start, goal from section");
        ResultSet rs = null;
        try {
            rs = selSection.executeQuery();
            while (rs.next()) {
                Section s = Section.getInstance(rs.getString(1), rs.getString(2));
                r.add(s.toString());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return r.toArray(new String[r.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSection(String section) {
        Section s = Section.fromString(section);
        Connection conn = null;
        try {
            conn = MarimiteConfig.getConnection();
            this.removeSectionImpl(conn, s);
        }
        catch (SQLException e) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e1) {}
            }
        }
    }

    public void removeSectionImpl(Connection conn, Section s) throws SQLException {
        long sectionId = s.getIdAsPersistent(conn, false);
        if (sectionId != -1L) {
            PreparedStatement delLap = conn.prepareStatement("delete from lap where section_id = ?");
            delLap.setLong(1, sectionId);
            PreparedStatement delSection = conn.prepareStatement("delete from section where id = ?");
            delSection.setLong(1, sectionId);
            delLap.executeUpdate();
            delSection.executeUpdate();
            try {
                conn.commit();
                s.disposeId();
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
    }
}

