/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import org.kaoriha.marimite.MarimiteConfig;
import org.kaoriha.marimite.Section;

class LapInserter
implements Runnable {
    private final long[] buffer;
    private final int size;
    private final Section section;
    private final Timestamp timestamp = new Timestamp(System.currentTimeMillis());

    public LapInserter(long[] buffer, int size, Section section) {
        this.buffer = (long[])buffer.clone();
        this.size = size;
        this.section = section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.size <= 1) {
            return;
        }
        Arrays.sort(this.buffer);
        Connection conn = null;
        try {
            conn = MarimiteConfig.getConnection();
            this.runImpl(conn);
        }
        catch (SQLException e) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e1) {}
            }
        }
    }

    private void runImpl(Connection conn) throws SQLException {
        long sectionId = this.section.getIdAsPersistent(conn);
        int medIdx = this.size / 2;
        int tailIdx = this.size * 95 / 100;
        PreparedStatement insLap = conn.prepareStatement("insert into lap (id, section_id, elapse_med, elapse_med_var, elapse_tail, elapse_tail_var, elapse_worst, elapse_worst_var, sample_date, n_sample) values (NEXT VALUE FOR seq_lap_id, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        insLap.setLong(1, sectionId);
        insLap.setDouble(2, this.buffer[medIdx]);
        insLap.setDouble(3, 0.0);
        insLap.setDouble(4, this.buffer[tailIdx]);
        insLap.setDouble(5, 0.0);
        insLap.setDouble(6, this.buffer[this.size - 1]);
        insLap.setDouble(7, 0.0);
        insLap.setTimestamp(8, this.timestamp);
        insLap.setInt(9, 1);
        insLap.executeUpdate();
        try {
            conn.commit();
        }
        catch (SQLException e) {
            conn.rollback();
            throw e;
        }
        insLap.close();
    }
}

