#! ruby -Ke
#
# $Id: marg.rb,v 1.2 2003/05/09 14:02:12 nisi Exp $
#

# --

$DB_SERVER    = 'localhost'
$DB_USER      = 'test'
$DB_PASSWORD  = ''
$DB_NAME      = 'test'

$DEFAULT_MARG = 'defaultmarg'

# --

require 'margarine.rb'
#require 'marg_win.rb'

marg_name = ARGV[0]

ctm = true
if marg_name =~ /^[a-z]+$/ then
	ctm = false
else
	marg_name = $DEFAULT_MARG
end

argvc = Hash[
	"Y","noname",
	"M",marg_name,
	"r","0" ]

while argv = ARGV.shift
	if argv =~ /^-[mncrpYMidh]/ then
		argvc["#{argv[1..1]}"] = argv[2..-1]
	elsif ctm
		print argv," ..?\n"
		exit(0)
	end
	ctm = true
end

marg = Margarine.new($DB_SERVER,$DB_USER,$DB_PASSWORD,$DB_NAME,marg_name)

if argvc["i"] or argvc["d"] or argvc["h"] then

	if argvc["h"] then
		print "help!\n"
		exit(0)
	end

	if argvc["d"] then
		marg.marg_list().each {|ma|
			print marg.get_infostr(ma)
		}
		exit(0)
	end

	if argvc["i"] then
		if marg.marg?(marg_name) then
			print marg_name + " Format, Delete or Cancel? [F/D/C] > "
			case gets.chop
			when "F"
				marg.setup_marg()
				print marg_name + " format ok.\n"
			when "D"
				marg.setup_marg("D")
				print marg_name + " delete ok.\n"
			else
			# ʡ⤷ʤǤ褫
			end
		else
			marg.setup_marg()
			print marg_name + " set up OK!\n"
		end
		exit(0)
	end
	exit(0) # ͡
end

marg.set_user(argvc["Y"])

if argvc["M"] then
	case argvc["M"][0..0]
		when "+"
			marg.add_marg_nick(argvc["M"][1..-1])
		when "-"
			marg.remove_marg_nick(argvc["M"][1..-1])
		else
			marg.set_marg_nick(argvc["M"])
	end
end

if argvc["m"] then
	argvc["m"].gsub!('\#\+\#',' ')
	argvc["m"].gsub!('\+\+','+')
	marg.put_message(argvc["m"],argvc["n"])
	print marg.get_message(argvc["r"],argvc["p"])
	exit(0)
end

if argvc["c"] then
	while true
		printf("< %10s > ", marg.username)
		c = gets
		break if c[0..0] == "\\"
		marg.put_message(c,argvc["n"])
		margmes = marg.get_message(argvc["r"],argvc["p"])
		if margmes != "" then
			printf("> %10s < ", marg.margnick)
			print margmes + "\n"
		end
	end
end

