/*

	Copyright (C) 1991-2001 and beyond by Bungie Studios, Inc.
	and the "Aleph One" developers.
 
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	This license is contained in the file "COPYING",
	which is included with this source code; it is available online at
	http://www.gnu.org/licenses/gpl.html

*/
/*
 *  csmisc_sdl.cpp - Miscellaneous routines, SDL implementation
 *
 *  Written in 2000 by Christian Bauer
 */

#include "cseries.h"


/*
 *  Return tick counter
 */

uint32 machine_tick_count(void)
{
	return SDL_GetTicks();
}


/*
 *  Wait for mouse click or keypress
 */

bool wait_for_click_or_keypress(uint32 ticks)
{
	uint32 start = SDL_GetTicks();
	SDL_Event event;
	while (SDL_GetTicks() - start < ticks) {
		SDL_PollEvent(&event);
		if (event.type == SDL_MOUSEBUTTONDOWN || event.type == SDL_KEYDOWN)
			return true;
		SDL_Delay(10);
	}
	return false;
}
