#include "MapEditorMainFrame.h"

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
// file menus

void MapEditorMainFrame::OnPrint(wxCommandEvent& ev)
{
    //}bv̑S̑TCYɍ킹Ĉ
}
void MapEditorMainFrame::OnPrintPreview(wxCommandEvent& ev)
{
}
void MapEditorMainFrame::OnPrintSetup(wxCommandEvent& ev)
{
}

void MapEditorMainFrame::initLevel()
{
    //
    wxGetApp().editLevelIndex = 0;
    build_trig_tables();
    //allocate
    if(dynamic_world == NULL){
        allocate_map_memory();
    }
    //Y[EItZbg
    wxCommandEvent dummy;
    this->OnZoomDefault(dummy);
    this->OnMoveToCenter(dummy);


    wxGetApp().getStockManager()->resetDeletes();
    wxGetApp().isChanged = false;
    //xꗗ폜
    wxGetApp().levelNameList.clear();
    initialize_map_for_new_level();
    //f[^̏
    wxGetApp().getStockManager()->resetDeletes();
    wxGetApp().getViewGridManager()->setViewHeightMin(SHRT_MAX);
    wxGetApp().getViewGridManager()->setViewHeightMin(SHRT_MIN);
}
void MapEditorMainFrame::OnNew(wxCommandEvent& ev)
{
    if(wxGetApp().isChanged){
        wxMessageDialog dlg(this, _T("Map has been modified. Are you sure that delete this and create new one?"));
        if(dlg.ShowModal() == wxID_CANCEL){
            //
            return;
        }
    }
    initLevel();


    //łɃxݒ
    //TODO
    //xݒ_CAO\
    LevelInfoDialog dlg;
    dlg.Create(this, wxID_ANY);
    dlg.ShowModal();
    //e}bvf[^ɔf
    //TODO

    Refresh();
}
void MapEditorMainFrame::OnNewLevel(wxCommandEvent& ev)
{
    //VKx쐬
    //TODO svH
    //}[WĂ}bv͕ۑłȂ


}

void MapEditorMainFrame::OnOpen(wxCommandEvent& WXUNUSED(ev))
{
    //TODO Z[u`FbN
    wxFileDialog fileDialog(this, _T("Choose a file"),
        _T("."), _T(""), _T("*.*"));

    if(fileDialog.ShowModal() == wxID_OK){
        wxString path = fileDialog.GetPath();

        //^Cg
        SetTitle(path);
        
        FileSpecifier mapFile = FileSpecifier(path.mb_str());

        //set map file
        set_map_file(mapFile);

        wxGetApp().filePath = path;
        //
        initLevel();

        //Level1ǂݍ
        bool check = load_level_from_map(wxGetApp().editLevelIndex);
        if(!check){
            wxMessageBox(_T("failed"));
        }

        //CfbNX
        wxGetApp().levelNameList.clear();
        {
            short index = 0;
            struct entry_point ep;
            int type = 3;
            char cstr[256];
            while(get_indexed_entry_point(&ep, &index, type)){
                sprintf(cstr, "%d", ep.level_number);
                wxGetApp().levelNameList.push_back(string(cstr) + string(ep.level_name));
            }
            if(wxGetApp().levelNameList.size() == 0){
                wxGetApp().levelNameList.push_back("unnamed");
            }
        }
        //ZbgAbv
        wxGetApp().getStockManager()->updateDeletes();
        //ĕ`
        Refresh();
    }
}void MapEditorMainFrame::OnSave(wxCommandEvent& ev)
{
    //TODO save correctly
    if(wxGetApp().isChanged){
        OnSaveAs(ev);
    }else{
        //݂̃t@Cŕۑ
        if(save_level(wxGetApp().filePath.mb_str())){
            wxGetApp().isChanged = false;
//            wxGetApp().filePath = fname;
        }else{
            hpl::error::caution("save failure");
        }
    }
}
void MapEditorMainFrame::OnSaveAs(wxCommandEvent& ev)
{
    int style = wxFD_SAVE | wxFD_OVERWRITE_PROMPT;
    wxString wildcard(_T("AlephOne map (*.sceA)|*.sceA|Any file|*.*"));
    wxFileDialog dlg(this, wxString(_T("Save at...")), 
        wxString(_T("")), wxString(_T("")), wildcard,
        style);
    if(dlg.ShowModal() == wxID_OK){
        //
        wxString fname = dlg.GetPath();
        SetTitle(fname);

        if(save_level(fname.mb_str())){
            wxGetApp().isChanged = false;
            wxGetApp().filePath = fname;
        }else{
            hpl::error::caution("save failure");
        }
    }
}

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
// edit menus
void MapEditorMainFrame::OnUndo(wxCommandEvent& ev)
{
}
void MapEditorMainFrame::OnCut(wxCommandEvent& ev)
{
}
void MapEditorMainFrame::OnCopy(wxCommandEvent& ev)
{
}
void MapEditorMainFrame::OnPaste(wxCommandEvent& ev)
{
}
void MapEditorMainFrame::OnPreference(wxCommandEvent& ev)
{
    //Call up editor preferences dialog
    EditorPreferencesDialog dlg;
    dlg.Create(this, wxID_ANY);
    if(dlg.ShowModal() == wxID_OK){
        //t@Cɕۑ
        if(!wxGetApp().setting.saveSetting()){
            hpl::error::caution("Fail to save setting as [%s]", wxGetApp().setting.getFilePath().c_str());
        }
        //y̍蒼
        setupPenAndBrush(wxGetApp().setting.getColorSetting());
        Refresh();
    }
}

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
// show/hide menus
void MapEditorMainFrame::OnToolDialog(wxCommandEvent& ev)
{
    this->toolDialog.Show(!this->toolDialog.IsShown());
}
void MapEditorMainFrame::OnZoomIn(wxCommandEvent& ev)
{
    wxSize size = this->GetSize();
    wxGetApp().getViewGridManager()->zoomIn(size.GetWidth(), size.GetHeight());
}
void MapEditorMainFrame::OnZoomOut(wxCommandEvent& ev)
{
    wxSize size = this->GetSize();
    wxGetApp().getViewGridManager()->zoomOut(size.GetWidth(), size.GetHeight());
}
void MapEditorMainFrame::OnZoomDefault(wxCommandEvent& ev)
{
    wxGetApp().getViewGridManager()->zoomReset();
}
void MapEditorMainFrame::OnMoveToCenter(wxCommandEvent& ev)
{
    //S[hW̐^񒆂ɗ悤ɂ
    wxGetApp().getViewGridManager()->setOffset(0,0);
}
void MapEditorMainFrame::OnHeightDialog(wxCommandEvent& ev)
{
    bool shown = this->heightDialog.IsShown();
    this->heightDialog.Show(!shown);
    if(shown){
        //TODO j[Ƀ`FbN
        //this->GetMenuBar()->GetMenu(0)->Get
    }else{
    }
}

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
// mode menus
/*
    [hX_CAOςɂȂ̂ŁAj[Iɐ؂ւ
    ꂼ̃[hŊJĂ\̂郂[hX_CAO͈ȉ̂Ƃ
    EDraw(Polygon)Mode
        __CAO        PointProp
        _CAO        LineProp
        |S_CAO  PolygonProp
        Side_CAO      SideProp
        IuWFNg_CAO  ObjectProp
    EPolygonType
        PolygonType
    EFloor/Ceiling HeightMode
        HeightPalette (setFloor(bool))
    EFloor/CeilingTexture
        Texture
    EMedia
        MediaPalette
    ELight
        LightPalette
*/

void MapEditorMainFrame::OnDrawPolygonMode(wxCommandEvent& ev)
{
    //݂̏Ԃ擾
    bool checked = ev.IsChecked();
    
    //O̒iK
    int editMode = wxGetApp().getEventManager()->getEditModeType();

    //USă`FbN͂܂
    this->uncheckModesOnMenu();

    //h[[hɂ܂
    wxGetApp().getEventManager()->setEditModeType(EditModeType::EM_DRAW);

    //S̃_CAO܂
    this->closeAllModelessDialogs();
}
void MapEditorMainFrame::closeAllModelessDialogs()
{
    this->objPropDialog.Show(false);
    this->pointPropDialog.Show(false);
    this->polyPropDialog.Show(false);
    this->linePropDialog.Show(false);
    this->sidePropDialog.Show(false);
    this->polyTypeDialog.Show(false);
    this->mediaPaletteDialog.Show(false);
    this->heightPaletteDialog.Show(false);
    this->lightPaletteDialog.Show(false);
    this->textureDialog.Show(false);
}

void MapEditorMainFrame::OnVisualMode(wxCommandEvent& ev)
{
    //[_\
    VisualDialog dlg;
    dlg.Create(this, wxID_ANY);
    if(dlg.ShowModal() == wxID_OK){
    }

}
void MapEditorMainFrame::OnPolygonTypeMode(wxCommandEvent& ev)
{
    //[hύX
    this->changeEditMode(EditModeType::EM_POLYGON_TYPE);

    //S̃_CAO܂
    this->closeAllModelessDialogs();

    //|S^Cv_CAO\
    this->polyTypeDialog.Show(true);
}
void MapEditorMainFrame::OnFloorHeightMode(wxCommandEvent& ev)
{
    //[hύX
    this->changeEditMode(EditModeType::EM_FLOOR_HEIGHT);

    //S̃_CAO܂
    this->closeAllModelessDialogs();

    //̍
    this->heightPaletteDialog.setFloor(true);
    //pbg_CAO\
    this->heightPaletteDialog.Show(true);
}
void MapEditorMainFrame::OnCeilingHeightMode(wxCommandEvent& ev)
{
    //[hύX
    this->changeEditMode(EditModeType::EM_CEILING_HEIGHT);

    //S̃_CAO܂
    this->closeAllModelessDialogs();

    //V̍
    this->heightPaletteDialog.setFloor(false);
    //pbg_CAO\
    this->heightPaletteDialog.Show(true);
}
void MapEditorMainFrame::OnFloorLightMode(wxCommandEvent& ev)
{
    //[hύX
    this->changeEditMode(EditModeType::EM_FLOOR_LIGHT);

    //S̃_CAO܂
    this->closeAllModelessDialogs();

    this->lightPaletteDialog.setFloor(true);
    //Cgpbg_CAO\
    this->lightPaletteDialog.Show(true);
}
void MapEditorMainFrame::OnCeilingLightMode(wxCommandEvent& ev)
{
    //[hύX
    this->changeEditMode(EditModeType::EM_CEILING_LIGHT);

    //S̃_CAO܂
    this->closeAllModelessDialogs();

    this->lightPaletteDialog.setFloor(false);
    //Cgpbg_CAO\
    this->lightPaletteDialog.Show(true);
}
void MapEditorMainFrame::OnMediaMode(wxCommandEvent& ev)
{
    //[hύX
    this->changeEditMode(EditModeType::EM_MEDIA);
 
    //S̃_CAO܂
    this->closeAllModelessDialogs();

    //fBApbg_CAO\
    this->mediaPaletteDialog.Show(true);
}
void MapEditorMainFrame::OnFloorTextureMode(wxCommandEvent& ev)
{
    //[hύX
    this->changeEditMode(EditModeType::EM_FLOOR_TEXTURE);

    //S̃_CAO܂
    this->closeAllModelessDialogs();

    //eNX`_CAO\
    this->textureDialog.setFloor(true);
    this->textureDialog.Show(true);
}
void MapEditorMainFrame::OnCeilingTextureMode(wxCommandEvent& ev)
{
    //[hύX
    this->changeEditMode(EditModeType::EM_CEILING_TEXTURE);

    //S̃_CAO܂
    this->closeAllModelessDialogs();

    this->textureDialog.setFloor(false);
    //eNX`_CAO\
    this->textureDialog.Show(true);
}

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
// special menus
void MapEditorMainFrame::OnJumpLevel(wxCommandEvent& ev)
{
    //TODO
    SelectLevelDialog dlg;
    dlg.Create(this, wxID_ANY);
    if(dlg.ShowModal() == wxID_OK){
    }
}
void MapEditorMainFrame::OnLevelInfo(wxCommandEvent& ev)
{
    //ۑmF
    if(wxGetApp().isChanged){
        if(wxMessageBox(_T("This level has been edited. Destruct it?"), _T("Message"), 
            wxOK | wxCANCEL) == wxCANCEL)
        {
            return;
        }
    }
    LevelInfoDialog dlg;
    dlg.Create(this, wxID_ANY);
    if(dlg.ShowModal() != wxCANCEL){
        //
        this->initLevel();
        
        int index = wxGetApp().editLevelIndex;
        //ǂݍ
        bool check = load_level_from_map(index);
        if(!check){
            hpl::error::caution("Loading level[%d] failure", index);
        }
        wxGetApp().getStockManager()->updateDeletes();
    }
}
void MapEditorMainFrame::OnObjectPlacement(wxCommandEvent& ev)
{
    //IuWFNgzu_CAO
    PlacementDialog dlg;
    dlg.Create(this, wxID_ANY);
    dlg.ShowModal();
}
void MapEditorMainFrame::OnTerminalViewer(wxCommandEvent& ev)
{
    //^[~i
    TerminalDialog dlg;
    dlg.Create(this, wxID_ANY);
    dlg.ShowModal();
}

//////////////////////////////////////////////////
//////////////////////////////////////////////////

void MapEditorMainFrame::OnLineProp(wxCommandEvent& ev)
{
    this->linePropDialog.setLineIndex(wxGetApp().popupLineIndex);
    this->linePropDialog.Show(true);
}
void MapEditorMainFrame::OnClockwiseSide(wxCommandEvent& ev)
{
    //TODO
    this->sidePropDialog.setIndex(get_line_data(wxGetApp().popupLineIndex)->clockwise_polygon_side_index);
    this->sidePropDialog.Show(true);
}
void MapEditorMainFrame::OnCounterclockwiseSide(wxCommandEvent& ev)
{
    //TODO
    this->sidePropDialog.setIndex(get_line_data(wxGetApp().popupLineIndex)->counterclockwise_polygon_side_index);
    this->sidePropDialog.Show(true);
}
void MapEditorMainFrame::OnPointProp(wxCommandEvent& ev)
{
    this->pointPropDialog.setIndex(wxGetApp().popupEndpointIndex);
    this->pointPropDialog.Show(true);
}
