/**
    <jp>gkAҏWʒuOffset̏CAWϊAXN[\Ȃ
        ܂Ƃ߂ĊǗ}l[W[ł
    <en>the manager that manage zooming in or out, offsets for editing, exchanging
        different coordinates, scrolling, and so on
*/
#ifndef _HPL_VIEW_GRID_MANAGER_
#define _HPL_VIEW_GRID_MANAGER_

const int NUMBER_OF_GLID = 5;
const int ZOOM_DIVISION_STEP = 5;
const int ZOOM_DIVISION_MAX = 200;
const int ZOOM_DIVISION_MIN = 1;
const int ZOOM_DIVISION_DEFAULT = 100;
const int OFFSET_X_WORLD = 32768;
const int OFFSET_Y_WORLD = 32768;


namespace hpl{
namespace aleph{
namespace view{
    struct ZoomProperties{
        /**̊gkŐω*/
        int zoomDivisionStep;

        /**g嗦臒l*/
        int zoomDivStepThreshold;

        /**g嗦̑x*/
        int zoomDivisionStepDetail;

        /**ől*/
        int zoomDivisionMax;

        /**ŏl*/
        int zoomDivisionMin;

        /**lEKl*/
        int zoomDivisionDefault;

        //Obh
        int gridIntervals[NUMBER_OF_GLID];

    };
    /**
        gkAXN[Ȃǂ̊Ǘ
    */
    class HPLViewGridManager{
    private:
        /**g֌W̒萔*/
        ZoomProperties zoomProperties;

        /**݂̊g劄*/
        int zoomDivision;

        /**ViewW̃ItZbg*/
        int viewOffset[2];

        //}EXWij
        int oldMousePoint[2];
        int newMousePoint[2];

        //Obh
        int gridIndex;

        //\EҏWł鍂
        int viewHeightMax;
        int viewHeightMin;
        //͈͊Õ|S\邩H
        bool isRevealHiddenLines_;
    public:
        HPLViewGridManager();
        void setProp(ZoomProperties *zoomProp);
        ~HPLViewGridManager();

    public:
        /**
            g嗦擾
            <en>get zoom division
        */
        int getZoomDivision();
        /**
            zoom in
            @param viewW, viewH View͈͂̃TCY
        */
        void zoomIn(int viewW, int viewH);

        /**
            zoom out
        */
        void zoomOut(int viewW, int viewH);

        /**
            g嗦
        */
        void zoomReset();

        //void setOldMousePoint(int x, int y);
        /**
            }EXWZbg܂
            set mouse position info (view coordinate)
        */
        void setNewMousePoint(int x, int y);
        void getNewMousePoint(int* point);
        void getOldMousePoint(int* point);

        void setOffset(int x, int y);
        void getOffset(int* point);
        void setViewHeightMax(int max);
        void setViewHeightMin(int min);
        int getViewHeightMax();
        int getViewHeightMin();
        void setRevealHiddenLines(bool show);
        bool isRevealHiddenLines();
        int getGridInterval();
        void setGridIntervalIndex(int index);

        //`FbN
        bool isValidHeight(int zMin, int zMax);
    private:
        /**
            Y[
            @param step ω
        */
        void addZoom(int step, int viewW, int viewH);
    };
};
};
};
#endif

