/*******************************************************************************
 * ManjyuRss
 * Copyright (C) 2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.manjyu.rss.vo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.manjyu.rss.ManjyuRssConstants;

import blanco.gettersetter.BlancoGetterSetter;

/**
 * RSS 2.0 Channel ValueObject
 * 
 * @see http://cyber.law.harvard.edu/rss/rss.html
 * @author Toshiki Iga
 */
public abstract class AbstractManjyuRssChannel {
	/**
	 * [required] The name of the channel.
	 */
	@BlancoGetterSetter
	protected String title;

	/**
	 * [required] The URL to the HTML website.
	 */
	@BlancoGetterSetter
	protected String link;

	/**
	 * [required] describe the channel.
	 */
	@BlancoGetterSetter
	protected String description;

	/**
	 * [optional] Language the channel is written in.
	 */
	@BlancoGetterSetter
	protected String language;

	/**
	 * [optional] Copyright notice for content in the channel. 
	 */
	@BlancoGetterSetter
	protected String copyright;

	/**
	 * [optional] Email address for person responsible for editorial content.
	 */
	@BlancoGetterSetter
	protected String managingEditor;

	/**
	 * [optional] Email address for person responsible for technical issues relating to channel.
	 */
	@BlancoGetterSetter
	protected String webMaster;

	/**
	 * [optional] The publication date for the content in the channel.
	 */
	@BlancoGetterSetter
	protected Date pubDate;

	/**
	 * [optional] The last time the content of the channel changed.
	 */
	@BlancoGetterSetter
	protected Date lastBuildDate;

	/**
	 * Includes the item in one or more categories.
	 */
	@BlancoGetterSetter(setter = false)
	protected List<ManjyuRssCategory> categoryList = new ArrayList<ManjyuRssCategory>();

	/**
	 * [optional] Indicate the program used to generate.
	 */
	@BlancoGetterSetter
	protected String generator = "Manjyu RSS Library (" + ManjyuRssConstants.VERSION + ")";

	/**
	 * [optional] Documentation for the format used in the RSS file.
	 */
	@BlancoGetterSetter
	protected String docs = "http://blogs.law.harvard.edu/tech/rss";

	/**
	 * [optional] cloud
	 */
	@BlancoGetterSetter
	protected ManjyuRssCloud cloud;

	/**
	 * [optional] ttl stands for time to live.
	 */
	@BlancoGetterSetter
	protected String ttl;

	/**
	 * [optional] image
	 */
	@BlancoGetterSetter
	protected ManjyuRssImage image;

	// rating

	// textInput

	// skipHours

	// skipDays
}
