package mandelbrotExplorer;

import javax.swing.JApplet;

public class MandelbrotExplorerApplet extends JApplet {

	private static final long serialVersionUID = 1L;
	
	Mandelbrot mandel;
	
	public MandelbrotExplorerApplet(){
		
	}
	
	@Override
	public void init() {
		double rLeft,rRight,iTop,iBottom;
		
		if( this.getParameter("r_left")!=null ){
			rLeft = Double.parseDouble( this.getParameter("r_left") );
		}else{
			rLeft=-2.0;
		}
		if( this.getParameter("r_right")!=null ){
			rRight = Double.parseDouble( this.getParameter("r_right") );
		}else{
			rRight=0.5;
		}
		if( this.getParameter("i_top")!=null ){
			iTop = Double.parseDouble( this.getParameter("i_top") );
		}else{
			iTop=1.25;
		}
		if( this.getParameter("i_bottom")!=null ){
			iBottom = Double.parseDouble( this.getParameter("i_bottom") );
		}else{
			iBottom=-1.25;
		}
		
		mandel = new Mandelbrot(rLeft, rRight, iTop, iBottom);
		this.getContentPane().add(mandel);
	}

}
