package jp.dip.commonsense.android.util;

import java.util.ArrayList;

import android.content.Intent;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.util.Log;

import com.google.android.gtalkservice.IChatSession;
import com.google.android.gtalkservice.IGTalkService;
import com.google.android.gtalkservice.IGTalkSession;
import com.google.android.gtalkservice.IGroupChatInvitationListener;
import com.google.android.gtalkservice.Presence;

public class GTalkUtils {
	private GTalkUtils() {
		//
	}
	public static IGTalkSession getDefaultSession(IBinder service) {
	    try {
			return IGTalkService.Stub.asInterface(service).getDefaultSession();
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static String getUserName(IGTalkSession session) {
		try {
			return session.getUsername();
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static Presence getPresence(IGTalkSession session) {
		try {
			return session.getPresence();
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static void requestRoster(IGTalkSession session) {
		try {
			session.requestRoster();
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static IChatSession createChatSession(IGTalkSession session, String to) {
		try {
			return session.createChatSession(to);
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static IChatSession getChatSession(IGTalkSession session, String to) {
		try {
			return session.getChatSession(to);
		} catch (DeadObjectException e) {
			log(e);
			return null;
		}
	}
	public static void endChatSession(IGTalkSession session, String contactName) {
		try {
			session.getChatSession(contactName).leave();
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static void removeContact(IGTalkSession session, String contact) {
		try {
			session.removeContact(contact);
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static void approveSubscriptionRequest(IGTalkSession session, String contact) {
		try {
			session.approveSubscriptionRequest(contact, null);
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static void declineSubscriptionRequest(IGTalkSession session, String contact) {
		try {
			session.declineSubscriptionRequest(contact);
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static boolean isConnected(IGTalkSession session) {
		try {
			return session.isConnected();
		} catch (DeadObjectException e) {
			log(e);
			return false;
		}
	}
	public static int getConnectionState(IGTalkSession session) {
		try {
			return session.getConnectionState();
		} catch (DeadObjectException e) {
			log(e);
			return -1;
		}
	}
	public static void setPresence(IGTalkSession session, int mode) {
		try {
        	Presence presence = new Presence();
        	presence.setStatus(mode);
        	session.setPresence(presence);
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static void setCustomPresence(IGTalkSession session, int mode, String status) {
		try {
        	Presence presence = new Presence(mode, status);
        	session.setPresence(presence);
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static void createGroupChatSession(IGTalkSession session, String nickname, ArrayList<String> contacts) {
		try {
        	session.createGroupChatSession(nickname, contacts.toArray(new String[] {}));
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static void addGroupChatInvitationListener(IGTalkSession session, IGroupChatInvitationListener listener) {
		try {
        	session.addGroupChatInvitationListener(listener);
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static void joinGroupChatSession(IGTalkSession session, String roomAddress) {
		try {
			session.joinGroupChatSession(roomAddress, "", "");
		} catch (DeadObjectException e) {
			log(e);
		}
	}
	public static void declineGroupChatInvitation(IGTalkSession session, String roomAddress) {
		try {
        	session.declineGroupChatInvitation(roomAddress);
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static void logout(IGTalkSession session) {
		try {
			session.logout();
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static void sendDataMessage(IGTalkSession session, String to, Intent intent) {
		try {
        	session.sendDataMessage(to, intent);
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	public static String[] getParticipants(IChatSession session) {
		try {
        	return session.getParticipants();
    	} catch (DeadObjectException e) {
    		log(e);
    		return null;
    	}
	}
	public static void inviteContact(IChatSession session, String contactName) {
		try {
        	session.inviteContact(contactName);
    	} catch (DeadObjectException e) {
    		log(e);
    	}
	}
	private static void log(Exception e) {
		Log.e(GTalkUtils.class.getName(), e.getMessage(), e);
	}
}
