package jp.dip.commonsense.android.util;

import jp.dip.commonsense.android.mametalk.R;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Base64Utils;
import android.provider.Im;
import android.provider.Im.AvatarsColumns;

public class AvatarUtils {

	private AvatarUtils() {
		//
	}
	
	public static Drawable resolveAvatarIcon(Context context, String contact) {
		Cursor avatarCursor = context.getContentResolver().query(Im.Avatars.CONTENT_URI, null, "contact='" + contact + "'", null, null);
        if (0 < avatarCursor.count()) {
        	avatarCursor.first();
			byte[] data = Base64Utils.decodeBase64(avatarCursor.getString(avatarCursor.getColumnIndex(AvatarsColumns.DATA)));
			Bitmap bm = BitmapFactory.decodeByteArray(data, 0, data.length);
			return new BitmapDrawable(bm);
		}
        return context.getResources().getDrawable(R.drawable.android_robot);
	}
}
