package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.R;
import jp.dip.commonsense.android.util.GTalkUtils;
import android.app.Dialog;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import android.provider.Im;
import android.provider.Im.SubscriptionsColumns;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

import com.google.android.gtalkservice.IGTalkSession;

public class SubscriptionRequestDialog extends Dialog implements View.OnClickListener {
	
	private ListView listView;
	private IGTalkSession gtalkSession;
	
	public SubscriptionRequestDialog(Context context, IGTalkSession gtalkSession) {
		super(context);
		this.gtalkSession = gtalkSession;
		setContentView(R.layout.subscription_request_dialog);
		setTitle(R.string.dialog_title_subscription_request);
		listView = (ListView)findViewById(android.R.id.list);
		listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
			@SuppressWarnings("unchecked")
			@Override
			public void onItemClick(AdapterView adapterview, View view, int i, long l) {
				CheckBox checkBox = (CheckBox)view.findViewById(R.id.contact_checkbox);
				checkBox.setChecked(!checkBox.isChecked());
			}
		});
		TextView emptyText = (TextView) findViewById(R.id.error_message_text);
		emptyText.setText(R.string.info_no_contacts);
		listView.setEmptyView(emptyText);
		Button approveButton = (Button) findViewById(R.id.approve_button);
		approveButton.setOnClickListener(this);
		Button declineButton = (Button) findViewById(R.id.decline_button);
		declineButton.setOnClickListener(this);
		fillData();
	}
	
	private void fillData() {
    	Cursor cursor = getContext().getContentResolver()
    			.query(Im.Subscriptions.CONTENT_URI, null, null, null, null);
    	listView.setAdapter(new SimpleCursorAdapter(getContext(), R.layout.selectable_contact_list_item, cursor,
    				new String[] { SubscriptionsColumns.USERNAME },
    				new int[] { R.id.nickname_text }));
    	if (cursor.count() == 0) {
    		((Button) findViewById(R.id.approve_button)).setVisibility(View.GONE);
    		((Button) findViewById(R.id.decline_button)).setVisibility(View.GONE);
    	}
    	cursor.registerContentObserver(new ContentObserver(new Handler()) {
			@Override
			public void onChange(boolean selfChange) {
				super.onChange(selfChange);
				((Button) findViewById(R.id.approve_button)).setVisibility(View.VISIBLE);
				((Button) findViewById(R.id.decline_button)).setVisibility(View.VISIBLE);
			}
        });
    }
	
	@Override
	public void onClick(View view) {
		int size = listView.getCount();
		int checkedCount = 0;
		for (int i = 0; i < size; i++) {
			View v = listView.getChildAt(i);
			CheckBox check = (CheckBox)v.findViewById(R.id.contact_checkbox);
			if (check.isChecked()) {
				TextView text = (TextView)v.findViewById(R.id.nickname_text);
				if (view.getId() == R.id.approve_button) {
					GTalkUtils.approveSubscriptionRequest(gtalkSession, text.getText().toString());
				} else {
					GTalkUtils.declineSubscriptionRequest(gtalkSession, text.getText().toString());
				}
				checkedCount++;
			}
		}
		TextView error = (TextView)findViewById(R.id.error_message_text);
		if (checkedCount == 0) {
			error.setVisibility(View.VISIBLE);
			error.setText(R.string.error_unchecked);
			return;
		}
		dismiss();
	}
}
