package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.R;
import android.app.Dialog;
import android.content.Context;
import android.database.Cursor;
import android.provider.Im;
import android.provider.Im.GroupMemberColumns;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;

public class ParticipantsDialog extends Dialog {
	
	private ListView listView;
	private long groupId;
	
	public ParticipantsDialog(Context context, long groupId) {
		super(context);
		setContentView(R.layout.simple_list);
		setTitle(R.string.dialog_title_participants);
		listView = (ListView)findViewById(android.R.id.list);
		listView.setEmptyView(findViewById(android.R.id.empty));
		this.groupId = groupId; 
		fillData();
	}
	
	private void fillData() {
		Cursor cursor = getContext().getContentResolver().query(
    			Im.GroupMembers.CONTENT_URI, null, GroupMemberColumns.GROUP + "=" + groupId, null, null);
    	listView.setAdapter(new SimpleCursorAdapter(getContext(), R.layout.simple_list_item, cursor,
    				new String[] { GroupMemberColumns.NICKNAME },
    				new int[] { R.id.text }));
    }
}
