package jp.dip.commonsense.android.mametalk.dialog;

import java.util.ArrayList;

import jp.dip.commonsense.android.mametalk.R;
import jp.dip.commonsense.android.util.GTalkUtils;
import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;

import com.google.android.gtalkservice.IGTalkSession;

public class GroupChatCreaterDialog extends AbstractGroupChatInvitationDialog {
	
	private IGTalkSession gtalkSession;
	
	public GroupChatCreaterDialog(Context context, IGTalkSession gtalkSession) {
		super(context);
		this.gtalkSession = gtalkSession;
	}

	@Override
	public void onClick(View view) {
		if (view.getId() == R.id.invite_button) {
			int size = getListView().getCount();
			ArrayList<String> contacts = new ArrayList<String>();
			for (int i = 0; i < size; i++) {
				View v = getListView().getChildAt(i);
				CheckBox check = (CheckBox)v.findViewById(R.id.contact_checkbox);
				if (check.isChecked()) {
					TextView text = (TextView)v.findViewById(R.id.nickname_text);
					contacts.add(text.getText().toString());
				}
			}
			TextView error = (TextView)findViewById(R.id.error_message_text);
			if (contacts.size() == 0) {
				error.setVisibility(View.VISIBLE);
				error.setText(R.string.error_unchecked);
				return;
			}
			GTalkUtils.createGroupChatSession(gtalkSession, "", contacts);
			dismiss();
		}
	}
}
