package jp.dip.commonsense.android.mametalk;

import jp.dip.commonsense.android.mametalk.dialog.ChatInvitationDialog;
import jp.dip.commonsense.android.mametalk.dialog.GroupChatCreaterDialog;
import jp.dip.commonsense.android.mametalk.dialog.PresenceDialog;
import jp.dip.commonsense.android.mametalk.dialog.SubscriptionRequestDialog;
import jp.dip.commonsense.android.util.AvatarUtils;
import jp.dip.commonsense.android.util.GTalkUtils;
import jp.dip.commonsense.android.util.MessageUtils;
import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.ComponentName;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.DialogInterface.OnClickListener;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.provider.Im;
import android.provider.Im.ChatsColumns;
import android.provider.Im.ContactsColumns;
import android.provider.Im.GroupMemberColumns;
import android.provider.Im.PresenceColumns;
import android.text.TextUtils;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.View;
import android.view.Window;
import android.view.Menu.Item;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gtalkservice.GTalkServiceConstants;
import com.google.android.gtalkservice.GroupChatInvitation;
import com.google.android.gtalkservice.IChatSession;
import com.google.android.gtalkservice.IGTalkSession;
import com.google.android.gtalkservice.IGroupChatInvitationListener;

public class ContactList extends ListActivity implements View.OnClickListener {
	
	IGTalkSession gtalkSession = null;
    //Normal Menu
	private static final int SHOW_PRESENCE_ID = Menu.FIRST ;
	private static final int INVITE_CONTACT_ID = Menu.FIRST + 1;
    private static final int CREATE_GROUPCHAT_ID = Menu.FIRST + 2;
    private static final int GTALK_SETTINGS_ID = Menu.FIRST + 3;
    //Context Menu
    private static final int REMOVE_CONTACT_ID = Menu.FIRST + 4;
    //Activity Result
    private static final int ACTIVITY_RESULT_CHAT = 1;
    private static final int ACTIVITY_RESULT_SETTINGS = 2;
    
    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        getWindow().requestFeature(Window.FEATURE_LEFT_ICON);
        setContentView(R.layout.contact_list);
        getListView().setOnPopulateContextMenuListener(new View.OnPopulateContextMenuListener() {
			public void onPopulateContextMenu(ContextMenu menu, View v, Object o) {
			    menu.add(Menu.SELECTED_ALTERNATIVE, REMOVE_CONTACT_ID, R.string.menu_remove_contact, R.drawable.user_delete);
			}
        });
        findViewById(R.id.request_image_button).setOnClickListener(this);
    }
    
	private ServiceConnection conn = new ServiceConnection() {
		public void onServiceConnected(ComponentName className, IBinder service) {
			gtalkSession = GTalkUtils.getDefaultSession(service);
	        if (gtalkSession == null) {
	        	Toast.makeText(ContactList.this, R.string.error_gtalk_session_not_found, Toast.LENGTH_LONG).show();
	        	return;
	        }
	        GTalkUtils.setPresence(gtalkSession, Im.PresenceColumns.AVAILABLE);
	        GTalkUtils.requestRoster(gtalkSession);
	        GTalkUtils.addGroupChatInvitationListener(gtalkSession, listener);
	        String contact = GTalkUtils.getUserName(gtalkSession);
	        setTitle(contact);
	        getWindow().setFeatureDrawable(Window.FEATURE_LEFT_ICON, AvatarUtils.resolveAvatarIcon(ContactList.this, contact));
		}
		
	    public void onServiceDisconnected(ComponentName className) {
	    	GTalkUtils.setPresence(gtalkSession, PresenceColumns.OFFLINE);
	        gtalkSession = null;
	    }
	    
	    private IGroupChatInvitationListener.Stub listener = new IGroupChatInvitationListener.Stub() {
			public void onInvitationReceived(GroupChatInvitation groupchatinvitation)
				throws DeadObjectException {
				final String roomAddress = groupchatinvitation.getRoomAddress();
				final AlertDialog.Builder dialog = new AlertDialog.Builder(ContactList.this)
					.setTitle(R.string.dialog_title_accept_invitaion)
					.setMessage(groupchatinvitation.getInviter() + getText(R.string.info_accept_invitaion))
					.setPositiveButton(R.string.button_ok, new OnClickListener() {
						public void onClick(DialogInterface dialog, int i) {
							GTalkUtils.joinGroupChatSession(gtalkSession, roomAddress);
							dialog.dismiss();
						}
					})
					.setNegativeButton(R.string.button_decline, new OnClickListener() {
						public void onClick(DialogInterface dialog, int i) {
							GTalkUtils.declineGroupChatInvitation(gtalkSession, roomAddress);
							dialog.dismiss();
				        }
					});
				runOnUIThread(new Runnable() {
					public void run() {
						dialog.show();
					}
				});
			}
		};
    };

	@Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        menu.add(Menu.SYSTEM, GTALK_SETTINGS_ID, R.string.menu_gtalk_settings, R.drawable.wrench);
        return true;
    }

    @Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		super.onPrepareOptionsMenu(menu);
		boolean havaItems = 0 < getListView().getCount(); 
		if (gtalkSession != null) {
			if (menu.findItem(INVITE_CONTACT_ID) == null) {
		        menu.add(Menu.ALTERNATIVE, SHOW_PRESENCE_ID, R.string.menu_show_presence, R.drawable.status_online);
		        menu.add(Menu.ALTERNATIVE, INVITE_CONTACT_ID, R.string.menu_invite_contact, R.drawable.user_add);
			}
	        if (havaItems) {
	        	if (menu.findItem(CREATE_GROUPCHAT_ID) == null) {
				    menu.add(Menu.ALTERNATIVE, CREATE_GROUPCHAT_ID, R.string.menu_create_groupchat, R.drawable.comments);
	        	}
			} else {
				menu.removeItem(CREATE_GROUPCHAT_ID);
			}
		} else {
			menu.removeGroup(Menu.ALTERNATIVE);
		}
		return true;
	}

	@Override
    public boolean onMenuItemSelected(int featureId,Item item) {
    	super.onMenuItemSelected(featureId, item);
        switch (item.getId()) {
        case INVITE_CONTACT_ID:
        	new ChatInvitationDialog(this, gtalkSession).show();
        	break;
        case REMOVE_CONTACT_ID:
        	GTalkUtils.removeContact(gtalkSession, getStringColumn(ContactsColumns.USERNAME));
        	break;
        case CREATE_GROUPCHAT_ID:
        	new GroupChatCreaterDialog(this, gtalkSession).show();
        	break;
        case SHOW_PRESENCE_ID:
        	new PresenceDialog(this, gtalkSession).show();
        	break;
        case GTALK_SETTINGS_ID:
        	launchXmppSettings();
        	break;
        }
        return true;
    }
    
    private void launchXmppSettings() {
    	ComponentName comp = new ComponentName( 
                "com.google.android.gtalksettings", 
                "com.google.android.gtalksettings.GTalkSettingsForwarder"); 
    	startSubActivity((new Intent()).setComponent(comp), ACTIVITY_RESULT_SETTINGS);
    }
    
    private void fillData() {
    	Cursor cursor = Im.Contacts.query(getContentResolver(), null);
    	startManagingCursor(cursor);
    	this.setListAdapter(new SimpleCursorAdapter(this, R.layout.contact_list_item, cursor,
    				new String[] { ContactsColumns.NICKNAME, ChatsColumns.LAST_UNREAD_MESSAGE, PresenceColumns.PRESENCE_CUSTOM_STATUS, ContactsColumns.USERNAME },
    				new int[] { R.id.nickname_text, R.id.new_message_image, R.id.custom_status_text, R.id.avatar_image }) {
    		@Override
    	    public void setViewText(TextView v, String text) {
    			String disp = text;
    			if(v.getId() == R.id.custom_status_text) {
    				String status = mCursor.getString(mCursor.getColumnIndex(PresenceColumns.PRESENCE_STATUS));
    				if (TextUtils.isEmpty(status)) {
    					disp = "";
    				} else if (Integer.parseInt(status) <= PresenceColumns.INVISIBLE) {
    					disp = "offline";
    				}
				}
    			v.setText(disp);
    		}
    		@Override
			public void setViewImage(ImageView v, String text) {
				if (v.getId() == R.id.new_message_image) {
					//VbZ[W摜̕\
					if (text != "") v.setImageResource(R.drawable.comment);
				} else {
					v.setImageDrawable(AvatarUtils.resolveAvatarIcon(ContactList.this, text));
				}
			}
    	});
    }
	
    private void initRequestButton() {
    	setRequestButtonEnabled();
    	getContentResolver().registerContentObserver(Im.Subscriptions.CONTENT_URI, true, new ContentObserver(new Handler()) {
			@Override
			public void onChange(boolean flag) {
				super.onChange(flag);
				setRequestButtonEnabled();
			}
    	});
    }
    
    void setRequestButtonEnabled() {
    	int requestCount = getContentResolver().query(Im.Subscriptions.CONTENT_URI, null, null, null, null).count();
		View button = findViewById(R.id.request_image_button);
		if (0 == requestCount) {
			button.setEnabled(false);
		} else {
			button.setEnabled(true);
		}
    }
    
    @Override
	public void onClick(View view) {
    	new SubscriptionRequestDialog(this, gtalkSession).show();
	}
    
	@Override
	protected void onResume() {
		super.onResume();
		bindService((new Intent()
			.setComponent(GTalkServiceConstants.GTALK_SERVICE_COMPONENT)), conn, 0);
		fillData();
		initRequestButton();
		getListView().requestFocus();
	}

	@Override
	protected void onPause() {
		super.onPause();
		unbindService(conn);
	}

	@SuppressWarnings("deprecation")
	@Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
		setSelection(position);
    	if (gtalkSession == null) {
    		MessageUtils.showMessage(this, getText(R.string.error_gtalk_service_not_connected));
    		return;
    	}
    	String contactName = getStringColumn(ContactsColumns.USERNAME);
    	IChatSession chatSession = null;
    	Intent i = null;
    	if (getLongColumn(ChatsColumns.GROUP_CHAT) == 1) {
    		chatSession = GTalkUtils.getChatSession(gtalkSession, contactName);
			i = new Intent(this, GroupChatClient.class);
			i.putExtra(GroupMemberColumns.GROUP, getLongColumn("chats_contact_id"));
		} else {
			chatSession = GTalkUtils.createChatSession(gtalkSession, contactName);
			i = new Intent(this, ChatClient.class);
			i.putExtra(ContactsColumns.PROVIDER, getLongColumn(ContactsColumns.PROVIDER));
			i.putExtra(ContactsColumns.ACCOUNT, getLongColumn(ContactsColumns.ACCOUNT));
		}
    	i.putExtra(ContactsColumns.USERNAME, contactName);
    	i.putExtra(Constants.EXTRA_CHAT_SESSION, chatSession.asBinder());
    	startSubActivity(i, ACTIVITY_RESULT_CHAT);
    }
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, String data, Bundle extras) {
		super.onActivityResult(requestCode, resultCode, data, extras);
		if (requestCode == ACTIVITY_RESULT_CHAT) {
			GTalkUtils.endChatSession(gtalkSession, data);
		}
	}

	private String getStringColumn(String columnName) {
		Cursor cursor = (Cursor)getListView().getSelectedItem();
		return cursor.getString(cursor.getColumnIndex(columnName));
	}
	private long getLongColumn(String columnName) {
		Cursor cursor = (Cursor)getListView().getSelectedItem();
		return cursor.getLong(cursor.getColumnIndex(columnName));
	}
	
}