#include "mnTextCtrl.h"

BEGIN_EVENT_TABLE(mnTextCtrl, wxTextCtrl)
	EVT_KEY_DOWN(mnTextCtrl::handleKeyDown)
END_EVENT_TABLE()

void mnTextCtrl::handleKeyDown(wxKeyEvent& event)
{
#ifdef __WXMSW__
	MSW_handleKeyDown(event);
#endif

#ifdef __WXMAC__
	MAC_handleKeyDown(event);
#endif

#ifdef __WXGTK__
	GTK_handleKeyDown(event);
#endif
}

void mnTextCtrl::MSW_handleKeyDown(wxKeyEvent& event)
{
	long pos, x, y, oldY;
	bool isLineUp   = FALSE;
	bool isLineDown = FALSE;

	if(event.ControlDown()) {
		pos = GetInsertionPoint();
		PositionToXY(pos, &x, &y);
		
		switch(event.GetKeyCode()){
			case 'N':  // Next line
				oldY = y;
				y++;
				isLineDown = TRUE;
				break;

			case 'P':  // Previous line
				oldY = y;
				y--;
				isLineUp = TRUE;
				break;

			case 'F':  // Forward
				x++;
				break;

			case 'B':  // Backward
				x--;
				break;

			case 'E':  // End of line
				x = GetLineLength(y);
				break;

			case 'A':  // Begin of line
				x = 0;
				break;

			case 'H':  // Backspace
				Remove(pos-1, pos);
				x--;
				break;

			case 'D':  // Delete
				Remove(pos, pos+1);
				break;

			default:
				event.Skip();
				return;
		}

		pos = XYToPosition(x, y);
		if(isLineUp){
			PositionToXY(pos, &x, &y);
			if(y != oldY - 1){
				pos = XYToPosition(GetLineLength(oldY-1), oldY-1);
			}
		}
		else if(isLineDown) {
			PositionToXY(pos, &x, &y);
			if(y != oldY + 1) {
				pos = XYToPosition(GetLineLength(oldY+1), oldY+1);
			}
		}
		SetInsertionPoint(pos);
		return;
	}
	event.Skip();
}

void mnTextCtrl::MAC_handleKeyDown(wxKeyEvent& event)
{
	long pos, x, y;

	if(event.ControlDown()) {
		pos = GetInsertionPoint();
		PositionToXY(pos, &x, &y);
		
		switch(event.GetKeyCode()){
			case 'N':  // Next line
				y++;
				x-=1;
				break;

			case 'P':  // Previous line
				y--;
				x-=1;
				break;

			case 'F':  // Forward
				x+=0;
				break;

			case 'B':  // Backward
				x-=2;
				break;

			case 'E':  // End of line
				x = GetLineLength(y);
				break;

			case 'A':  // Begin of line
				x = 0;
				break;

			case 'H':  // Backspace
				Remove(pos-1, pos);
				x-=2;
				break;

			case 'D':  // Delete
				Remove(pos, pos+1);
				x-=1;
				break;

			default:
				event.Skip();
				return;
		}

		pos = XYToPosition(x, y);
		SetInsertionPoint(pos);
		return;
	}
	event.Skip();
}

void mnTextCtrl::GTK_handleKeyDown(wxKeyEvent& event)
{
	MSW_handleKeyDown(event);
}
