#ifndef MNMODEL_H
#define MNMODEL_H

#include <wx/wx.h>
#include <wx/treebase.h>

#include "config.h"

#define MAX_WIKI_TEXT_SIZE (1048576*5)
#define MAX_TOKEN          32
#define MAX_BUF_SIZE       1024
#define EXT_TAG             ".txt"
#define DATE_TAG            ":''DATE'':"
#define TYPE_TAG            ":''TYPE'':"
#define NEW_DATA            DATE_TAG " %Y/%m/%d %H:%M:%S\n\n" TYPE_TAG " memo\n---------------------------------------------------------\n"
#define NEW_DATA_TEMPLATE   "new.template"

#define ALLMEMO_TAG         "malon-all"
#define TYPESEARCH_TAG      "malon-type:"

#define CODE_SET_EUC_JP	    "eucJP"
#ifdef __WXMAC__
	#define CODE_SET_SYSTEM "CP932"
#endif
#ifdef __WXCOCOA__
	#define CODE_SET_SYSTEM "CP932"
#endif
#ifdef __WXMSW__
	#define CODE_SET_SYSTEM "CP932"
#endif
#ifdef __WXMOTIF__
	#define CODE_SET_SYSTEM "eucJP"
#endif
#ifdef __WXGTK__
	#define CODE_SET_SYSTEM "euc-jp"
#endif
#ifdef __WXX11__
	#define CODE_SET_SYSTEM "eucJP"
#endif

#define MAC_BACKSLASH 0x80


class WikiData : wxTreeItemData{

public:
	WikiData(wxString* dataDir, wxString* fileName);
	WikiData(wxString* dataDir); 
	~WikiData();
	const wxString* getFileName();
	const wxString* getSubject();
	const wxString* getOldSubject();
	const wxString* getDate();
    const wxString* getText();
    void  modText(wxString* text);
    void  modSubject(wxString* newName);
	void  save();
	void  removeDataFile();
	void  setOldSubjectFromCurrent(); 

private:
	wxString* subject;
	wxString* oldSubject;
	wxString* dataDirName;
	wxString* fileName;
	wxString* date;
	wxString* text;
	bool      isWriteToFile;
};

/* Search Result List */
WX_DECLARE_LIST(WikiData, WikiList);

/* Search Result Hash (Key is search string) */
WX_DECLARE_STRING_HASH_MAP(WikiList*, WikiHash);


class mnModel {

public:
    mnModel(const char* dataDir);
    ~mnModel();
	bool makeSearchToken(const char* searchStr, char* tokenList[]);
	bool matchWithToken(wxString* fileName, char* tokenList[]);
    WikiList* search(const char* searchStr);
	void group();
	bool normalSearch(char* tokenList[], FILE*fp, char* decodeFileNameBuf);
	bool typeSearch(char* typeStr, FILE*fp);
    void addWikiData(WikiData* wikiData);
	bool addSearchStr(wxString* searchStr);
	void addSearchList(wxString* searchStr, WikiList* list);
	void removeSearchStr(wxString searchStr);
	void modSearchStr(wxString* oldStr, wxString* newStr);
	const wxArrayString* getSearchStrList();
	const WikiList* getSearchResultList(wxString* searchStr);
	void addSearchResultList(wxString* searchStr, WikiData* addData);
	bool delSearchResultList(wxString* searchStr, WikiData* delData);
	WikiData* newWikiData();
	const wxString* getWikiDataDir();
	void clearSearchStrList();
	void clearSearchResultList();
private:
    wxString*      wikiDataDir;
	wxArrayString* searchStrList;
	WikiHash       wikiHash;
};


#endif //MNMODEL_H
