#ifndef MNHTMLWINDOW_H
#define MNHTMLWINDOW_H

#include <wx/wxhtml.h>


#ifdef __WXMAC__
#include <wx/html/webkit.h>
#endif

DECLARE_EVENT_TYPE(mnEVT_LINK_CLICK, -1)

#ifdef __WXMAC__
class mnHtmlWindow : public wxWebKitCtrl {
#else
class mnHtmlWindow : public wxHtmlWindow {
#endif

DECLARE_DYNAMIC_CLASS(mnHtmlWindow)
public:
#ifdef __WXMAC__
	mnHtmlWindow() : wxWebKitCtrl() {}
	mnHtmlWindow(wxWindow *parent) : wxWebKitCtrl(parent, wxID_HIGHEST + 1, wxT("")) {}
	mnHtmlWindow(wxWindow *parent, wxWindowID id, const wxString& url, const wxPoint& pos, const wxSize& size) : wxWebKitCtrl(parent, id, url, pos, size) {}
	bool SetPage(const wxString& source); 
#else
	mnHtmlWindow() : wxHtmlWindow() {}
	mnHtmlWindow(wxWindow *parent) : wxHtmlWindow(parent) {}
	mnHtmlWindow(wxWindow *parent, wxWindowID id) : wxHtmlWindow(parent, id) {}
#endif

	virtual void mnHtmlWindow::OnLinkClicked(const wxHtmlLinkInfo& link);
};


#endif
