require 'inputDataModel'
require 'config'

class OutgoRecord < AccountRecord
	def initialize(csv_cel)
		@variable_list = ["@goods", "@kind", "@price", "@shop", "@source"]
		@var_kind_list = ["string", "string","integer","string","string"]

		@goods  = nil # ̾
		@kind   = nil # 
		@price  = nil # 
		@shop   = nil # 
		@source = nil # 갷ʸ¡ۡ

		super
	end
	attr_reader :goods, :kind, :price, :shop, :source
end

class OutgoModel < InputDataModel
	
	def initialize(t_day, t_user, b_user)
		super(t_day, t_user, b_user, "OutgoRecord", ".dailyExp")
		@conf = Configuration.new(@target_user, @base_user)
	end

	def kind_list
		return @conf.kind_list
	end

	def source_list
		return @conf.source_list
	end

	def sum_of_outgo
		sum = 0
		@data_list.each do |data|
			sum += data.price
		end
		return sum
	end

	def copy_to(to_date)
		copy = OutgoModel.new(to_date, @target_user, @base_user)
		@data_list.each do | data |
			copy.add(data)
		end
		return copy
	end
end


=begin TEST
model = OutgoModel.new('20061122', 'hiroyuki', 'hiroyuki')
model.each do |data|
	print data.data
end

copy = model.copy_to('20061217')

#copy = OutgoModel.new('20061122', 'hiroyuki', 'hiroyuki')
copy.each do |data|
	print data.data
end

=end



