
require 'parsedate'
require 'date'

module StrDate

	# str_date: yyyymmdd
    def next_str_date(str_date)
		d = str_to_date(str_date)
		d += 1
		return sprintf("%04d%02d%02d", d.year, d.month, d.day)
	end

	# str_date: yyyymmdd
    def prev_str_date(str_date)
		d = str_to_date(str_date)
		d -= 1
		return sprintf("%04d%02d%02d", d.year, d.month, d.day)
	end

	# str_date: yyyymmdd
	def str_to_date(str_date)
		d = ParseDate.parsedate(str_date)

		begin
			result = Date.new(d[0], d[1], d[2])
			return result
		rescue ArgumentError
			if d[2] >= 29 then
				d[2] = 28
				retry
			else
				raise str_date + " is invalid date."
			end
		end
	end

end

