#!/usr/bin/ruby
$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
require 'controller'
require 'outgoModel'


include WEBrick
include ERB::Util

class OutgoController < Controller

	def initialize(server, *options)
		super
		@menu = TabMenu.new("account.menu")
		@outgo_model = nil
	end

	def init_outgo_model(req)
		if req.query["target_date"] == nil then
			today = Date.today
			@t_date = sprintf("%04d%02d%02d", today.year, today.month, today.day)
		else
			@t_date = req.query["target_date"]
		end
		@t_user = req.query["target_user"]
		@b_user = req.query["base_user"]
		@index  = req.query["index"].to_i

		@outgo_model = OutgoModel.new(@t_date, @t_user, @b_user)
	end

	def entry(req, res)
		init_outgo_model(req)
		set_view(req, res, "view/outgo.rhtml")
	end

	def copy_complete(req, res)
		@outgo_copy_complete = true;
		entry(req, res)
	end

	def add(req, res)
		init_outgo_model(req)
		record = OutgoRecord.new(nil)
		record.init_with_args(req.query["goods"],
                              req.query["kind"],
                              req.query["price"],
                              req.query["shop"],
                              req.query["source"])
		@outgo_model.add(record)

		# 򤵤줿̤Ƭ˰ư
		kind_record = ListRecord.new(nil)
		kind_record.init_with_args(req.query["kind"])
		kind_list = @outgo_model.kind_list
		kind_list.to_top(kind_record)

		forward_event(req, res, "/outgo", "entry")
	end
	
    def del(req, res)
		init_outgo_model(req)
		@outgo_model.delete(@index)
		forward_event(req, res, "/outgo", "entry")
	end

    def mod(req, res)
		init_outgo_model(req)
		record = OutgoRecord.new(nil)
		record.init_with_args(req.query["goods"],
                              req.query["kind"],
                              req.query["price"],
                              req.query["shop"],
                              req.query["source"])
		@outgo_model.modify(record, @index)

		# 򤵤줿̤Ƭ˰ư
		kind_record = ListRecord.new(nil)
		kind_record.init_with_args(req.query["kind"])
		kind_list = @outgo_model.kind_list
		kind_list.to_top(kind_record)

		forward_event(req, res, "/outgo", "entry")
	end

    def copy(req, res)
		init_outgo_model(req)
		@outgo_model.copy_to(req.query["date_to_copy"])
		req.query['target_date'] = req.query['date_to_copy']
		forward_event(req, res, "/outgo", "copy_complete")
	end
end
