#!/usr/bin/ruby
$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
require 'controller'
require 'balanceModel'


include WEBrick
include ERB::Util

class BalanceController < Controller

	def initialize(server, *options)
		super
		@menu = TabMenu.new("account.menu")
		@balanceModel = nil
	end

	def entry(req, res)
		if req.query["target_date"] == nil then
			today = Date.today
			t_date = sprintf("%04d%02d%02d", today.year, today.month, today.day)
		else
			t_date = req.query["target_date"]
		end
		t_user = req.query["target_user"]
		b_user = req.query["base_user"]

		# ܂ł̎c
		@balanceModel = BalanceModel.new(t_date, t_user, b_user, false)      
		
		# ̎c
		@balanceModel_of_month = BalanceModel.new(t_date, t_user, b_user, true)
		set_view(req, res, "view/balance.rhtml")
	end
end
