require 'inputDataModel'
require 'config'

class TakeoutRecord < AccountRecord
	def initialize(csv_cel)
		@variable_list = ["@account_name", "@price"]
		@var_kind_list = ["string",        "integer"]

		@account_name  = nil # 
		@price         = nil # oz

		super
	end
	attr_reader :account_name, :price
end

class TakeoutModel < InputDataModel
	

	def initialize(t_day, t_user, b_user)

		super(t_day, t_user, b_user, "TakeoutRecord", ".dailyAccount")
		@conf = Configuration.new(@target_user, @base_user)

	end

	def source_list
		return @conf.source_list
	end
	
	def sum_of_takeout
		sum = 0
		@data_list.each do |data|
			sum += data.price
		end
		return sum
	end

end


=begin TEST
model = TakeoutModel.new('20060202', 'kakei', 'kakei')
model.each do |data|
	print data.data
end

=end



