require 'inputDataModel'
require 'const'
require 'outgoModel'
if RUBY_PLATFORM.include?(Const::MACOS) then
	require 'uconv'
elsif RUBY_PLATFORM.include?(Const::MSWIN) then
	require 'kconv'
end

class KanjiConv
	def KanjiConv.to_euc(str)
		if RUBY_PLATFORM.include?(Const::MACOS) then
			return Uconv.u8toeuc(str)
		elsif RUBY_PLATFORM.include?(Const::MSWIN) then
			return Kconv.toeuc(str)
		end
	end

	def KanjiConv.to_utf8(str)
		if RUBY_PLATFORM.include?(Const::MACOS) then
			return Uconv.euctou8(str)
		elsif RUBY_PLATFORM.include?(Const::MSWIN) then
			return Kconv.toutf8(str)
		end
	end
end

class SuggestModel

	def initialize(goods, t_user, b_user)
		@target_user = t_user

		@goods = KanjiConv.to_euc(goods) #֥饦 UTF-8 Ƥ
	end

	def get_suggest
		today     = Date.today
		end_day   = Date.today - 360
		day_count = 0
		today.step(end_day, -1) do |date|
			date_str  = sprintf("%04d%02d%02d",date.year, date.month, date.day)
			path = Const::DATADIR + "/" + @target_user + "/" + date_str + ".dailyExp"
			@data_list   = AccountDataList.new(path, "OutgoRecord")
			@data_list.each do | data |
				if data.goods.include?(@goods) then
					utf_data = OutgoRecord.new(nil)
					utf_data.init_with_args(KanjiConv.to_utf8(data.goods),
                                            KanjiConv.to_utf8(data.kind),
                                            data.price,
                                            KanjiConv.to_utf8(data.shop),
                                            KanjiConv.to_utf8(data.source)
                                            )
					return data
				end
			end

			day_count += 1 if @data_list.value_at(0) != nil
			break if day_count >=  30 
		end
		
		return nil
	end

end

=begin
model = SuggestModel.new("", "kakei","kakei")

p model.get_suggest
=end
