require 'inputDataModel'
require 'const'


class BookRecord < AccountRecord
	def initialize(csv_cel)
		@variable_list = ["@user_name", "@name",  "@password"]
		@var_kind_list = ["string",     "string", "string"]

		@user_name  = nil # Ѹ̾
		@name       = nil # ȷ̾(ܸ̾)
		@password   = nil # ѥ

		super
	end
	attr_reader :user_name, :name, :password
end

class BookModel < InputDataModel
	def initialize
		@can_write   = true
		
		path = Const::DATADIR + "/db.conf.shadow"
		@data_list   = AccountDataList.new(path, "BookRecord")
	end

	# 顼ˤ 㳰 Errno::EXXX ȯ
	def add(record)
		record.user_name.strip!
		if (!valid_name?(record.user_name)) then
			fail "桼̾ˤ - (ϥե)ʳεϻѤǤޤ"
		end

		if RUBY_PLATFORM.include?(Const::MACOS) then
			path = Const::DATADIR + "/" + record.user_name
		elsif RUBY_PLATFORM.include?(Const::MSWIN) then
			path = Const::DATADIR + "\\" + record.user_name
		end
		if (File.exist?(path)) then
			fail record.user_name + "ϴ¸ߤƤޤ¾̾ꤷƤ"
		end

		#桼ǥ쥯ȥκȥǥեȤե륳ԡ
		Dir.mkdir(path)	
		if RUBY_PLATFORM.include?(Const::MACOS) then
			system("cp \"" + Const::DATADIR + "/.default/\"* \"" + path + "\"")
		elsif RUBY_PLATFORM.include?(Const::MSWIN) then
			system("copy \"" + Const::DATADIR + "\\.default\\*\" \"" + path + "\"")
		end
		super(record)
	end

	def modify(record, index)
		record.user_name.strip!
		if (!valid_name?(record.user_name)) then
			fail "桼̾ˤ - (ϥե)ʳεϻѤǤޤ"
		end

		if RUBY_PLATFORM.include?(Const::MACOS) then
			path_from  = Const::DATADIR + "/" + @data_list.value_at(index).user_name
			path_to    = Const::DATADIR + "/" + record.user_name
		elsif RUBY_PLATFORM.include?(Const::MSWIN) then
			path_from  = Const::DATADIR + "\\" + @data_list.value_at(index).user_name
			path_to    = Const::DATADIR + "\\" + record.user_name
		end

		if (path_from != path_to && File.exist?(path_to)) then
			fail record.user_name + "ϴ¸ߤƤޤ¾̾ꤷƤ"
		end

		#桼ǥ쥯ȥΰư (from, toۤʤΤ)
		if (path_from != path_to) then
			File.rename(path_from, path_to)
		end
	
		super(record, index)
	end
	
	def delete(index)
		if RUBY_PLATFORM.include?(Const::MACOS) then
			#桼ǥ쥯ȥκʼºݤˤ.trashȤ̾Τѹ
			path_from  = Const::DATADIR + "/" + @data_list.value_at(index).user_name
			path_to    = Const::DATADIR + "/.trash"
			system("mv \"" + path_from + "\" \"" + path_to + "\"")
		elsif RUBY_PLATFORM.include?(Const::MSWIN) then
			#桼ǥ쥯ȥκʼºݤˤ.trashȤ̾Τѹ
			path_from  = Const::DATADIR + "\\" + @data_list.value_at(index).user_name
			path_to    = Const::DATADIR + "\\.trash"
			system("move \"" + path_from + "\" \"" + path_to + "\"")
		end
		super(index)
	end

	def valid_name?(user_name)
		if (user_name.include?(" ") or 
            user_name.include?("*") or
            user_name.include?("?") or
            user_name.include?(">") or
            user_name.include?("<") or
            user_name.include?("!") or
            user_name.include?("~") or
            user_name.include?("/") or
            user_name.include?("[") or
            user_name.include?("]") or  
            user_name.include?("#") or  
            user_name.include?("$") or  
            user_name.include?("%") or  
            user_name.include?("&") or  
            user_name.include?("'") or  
            user_name.include?("(") or  
            user_name.include?(")") or  
            user_name.include?("=") or  
            user_name.include?("^") or  
            user_name.include?("|") or  
            user_name.include?("\\") or  
            user_name.include?("\"") or  
            user_name.include?("+") or  
            user_name.include?(";") or  
            user_name.include?(":") or  
            user_name.include?(",") or  
            user_name.include?(".") or  
            user_name.include?("@") or  
            user_name.include?("`") or  
            user_name.include?("_") or  
            user_name.include?("{") or  
            user_name.include?("}")   ) then
			return false
		end
		return true
	end
end

=begin
b = BookModel.new
r = BookRecord.new(nil)
r.init_with_args("kakei2", "TESTING")

#b.modify(r, "kake-pass222", 0)
b.delete(1)

b.each do | book |
  print book.user_name + "\n"
  print book.name + "\n"
end

=end
