#!/usr/bin/ruby
$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
require 'controller'
require 'bookModel'
require 'md5'


include WEBrick
include ERB::Util

class BookController < Controller

	def initialize(server, *options)
		super
		@menu = TabMenu.new("home.menu")
		@book_model = nil
	end

	def init_book_model(req)
		@index  = req.query["index"].to_i
		@book_model = BookModel.new
	end

	def entry(req, res)
		if !@base_user.is_guest then
			@base_user.to_guest  # Ū˥Ȥ
			@book_is_autologout = true
		end
		init_book_model(req)
		set_view(req, res, "view/book.rhtml")
	end
			
	def fail_book(req, res)
		init_book_model(req)
		set_view(req, res, "view/bookfail.rhtml")
	end

	def add(req, res)
		init_book_model(req)
		record = BookRecord.new(nil)
		record.init_with_args(req.query["user_name"],
                              req.query["book_name"],
                              MD5.new(req.query["user_name"] + req.query["book_password"]))
		begin 
			@book_model.add(record)
			forward_event(req, res, "/book", "entry")
		rescue 
			forward_event(req, res, "/book", "fail_book")
		end
	end
	
    def del(req, res)
		init_book_model(req)
		begin 
			@book_model.delete(@index)
			forward_event(req, res, "/book", "entry")
		rescue
			forward_event(req, res, "/book", "fail_book")
		end
	end

    def mod(req, res)
		init_book_model(req)
		record = BookRecord.new(nil)
		record.init_with_args(req.query["user_name"],
                              req.query["book_name"],
                              MD5.new(req.query["user_name"] + req.query["book_password"]))
		begin 
			@book_model.modify(record, @index)
			forward_event(req, res, "/book", "entry")
		rescue
			forward_event(req, res, "/book", "fail_book")
		end
	end
end
