#!/usr/bin/ruby

$KCODE = 'eucJP'

$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
include WEBrick

require 'rootController'
require 'loginController'
require 'logoutController'
require 'homeController'
require 'outgoController'
require 'incomeController'
require 'takeoutController'
require 'balanceController'
require 'aboutController'
require 'configController'
require 'bookController'
require 'histController'
require 'suggestController'
require 'userInfo'

MA_PORT = 50001

if ARGV[0] then
    ma_port = ARGV[0].to_i
else
 	ma_port = MA_PORT
end

BasicSocket.do_not_reverse_lookup=TRUE;

s = HTTPServer.new( :Port => ma_port, :DocumentRoot => './view')

s.mount('/',       RootController)
s.mount('/login',  LoginController)
s.mount('/logout', LogoutController)
s.mount('/home',   HomeController)
s.mount('/outgo',  OutgoController)
s.mount('/income', IncomeController)
s.mount('/takeout',TakeoutController)
s.mount('/balance',BalanceController)
s.mount('/history',HistController)
s.mount('/config' ,ConfigController)
s.mount('/about'  ,AboutController)
s.mount('/book'   ,BookController)
s.mount('/suggest',SuggestController)
s.mount('/init'   ,InitController)

trap("INT"){ s.shutdown }
s.start
