require 'accountData'
require 'StrDate'
require 'const'


#
# ϥǡζ̥ǥ
#
class InputDataModel
	
	include StrDate

	#
	# target_date  : ǡ(yyyymmdd)
	# target_user : ǡνͭ
	# base_user   : ǡ˥桼
	# record_class: ǡΥ饹̾
	#
	def initialize(t_day, t_user, b_user, record_class, extention)

		@target_date  = t_day
		@target_user = t_user
		@base_user   = b_user
		@can_write   = (t_user == b_user)
		
		path = Const::DATADIR + "/" + t_user + "/" + t_day + extention
		@data_list   = AccountDataList.new(path, record_class)

	end

	attr_reader :target_date, :target_user, :can_write

	def add(record)
		if @can_write then
			@data_list.add(record)
		else
			fail "Permission error, You can't modify another user's data"
		end
	end
	
	def modify(record, index)
		if @can_write then
			@data_list.modify(record, index)	
		else
			fail "Permission error, You can't modify another user's data"
		end
	end
	
	def delete(index)
		if @can_write then
			@data_list.delete(index)	
		else
			fail "Permission error, You can't modify another user's data"
		end
	end
	
	def to_top(record)
		if @can_write then
			@data_list.to_top(record)	
		else
			fail "Permission error, You can't modify another user's data"
		end
	end

	def each_with_index(&block)
		@data_list.each_with_index(&block)
	end

	def each(&block)
		@data_list.each(&block)
	end

end
