#!/usr/bin/ruby
$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
require 'controller'
require 'homeController'
require 'initController'

include WEBrick
include ERB::Util

class RootController < Controller

	def initialize(server, *options)
		super

		# ֺǽɽ̤Υȥ
		if File.exist?(Const::DATADIR) then
			@home_ctrl = HomeController.new(@server, nil)
		else
			@home_ctrl = InitController.new(@server, nil)
		end
			
		# / mount뤿ᡢǥեȤưFileHander˰Ѿ
		@fh = HTTPServlet::FileHandler.new(server, server.config[:DocumentRoot])
	end
  
	def do_GET(req, res)
		case req.request_uri.path
		when "/"
			@home_ctrl.entry(req, res)
		else 
			@fh.do_GET(req, res)
		end
	end
end

