require 'inputDataModel'
require 'config'

class OutgoRecord < AccountRecord
	def initialize(csv_cel)
		@variable_list = ["@goods", "@kind", "@price", "@shop", "@source"]
		@var_kind_list = ["string", "string","integer","string","string"]

		@goods  = nil # i
		@kind   = nil # 
		@price  = nil # i
		@shop   = nil # d
		@source = nil # 舵i^zj

		super
	end
	attr_reader :goods, :kind, :price, :shop, :source
end

class OutgoModel < InputDataModel
	
	
	def initialize(t_day, t_user, b_user)
		super(t_day, t_user, b_user, "OutgoRecord", ".dailyExp")
		@conf = Configuration.new(@target_user, @base_user)
	end

	def kind_list
		return @conf.kind_list
	end

	def source_list
		return @conf.source_list
	end

	def sum_of_outgo
		sum = 0
		@data_list.each do |data|
			sum += data.price
		end
		return sum
	end
end


=begin TEST
model = OutgoModel.new('20060201', 'kakei', 'kakei')
model.each do |data|
	print data.data
end

=end



