require 'inputDataModel'
require 'config'

class IncomeRecord < AccountRecord
	def initialize(csv_cel)
		@variable_list = ["@subject", "@price", "@source"]
		@var_kind_list = ["string",   "integer", "string"]

		@subject  = nil # 
		@price    = nil # i
		@source   = nil # 舵i^zj

		super
	end
	attr_reader :subject, :price, :source
end

class IncomeModel < InputDataModel
	

	def initialize(t_day, t_user, b_user)

		super(t_day, t_user, b_user, "IncomeRecord", ".dailyIncome")
		@conf = Configuration.new(@target_user, @base_user)
	end

	def source_list
		return @conf.source_list
	end

	def sum_of_income
		sum = 0
		@data_list.each do |data|
			sum += data.price
		end
		return sum
	end

end


=begin TEST
model = IncomeModel.new('20060209', 'kakei', 'kakei')
model.each do |data|
	print data.data
end

=end



