#!/usr/bin/ruby
$:.unshift('./lib')
require 'config'
require 'webrick'
require 'erb'
require 'userInfo'
require 'tabMenu'
require 'const'

include WEBrick
include ERB::Util

class Controller < HTTPServlet::AbstractServlet

	def initialize(server, *options)
		# ERB֥
		@erb = nil

		# 桼
		@base_user = UserInfo.new()
		@base_user.to_guest

		# оݥ桼
		@target_user = UserInfo.new()
		@base_user.to_guest

		# ˥塼֥
		@menu = TabMenu.new("home.menu")
		@menu.enable_login

		# ȷΥꥹ(Ѹ̾(target_user) ,ܸ̾Υϥå)
		@db_list = Hash.new

		begin
			File.open( Const::DATADIR + "/db.conf" ) do |file|
				file.each do |line|
					eng, jpn = line.chomp.split( /,/ )
					@db_list.store(eng, jpn)
				end
			end
		rescue
			# do nothing
		end

		super

	end

	# :
	# user/passȤ߹碌$HOME/MalonAccountData/db.conf
	# ƤȰפ뤫ǧڤ
	#
	# :
	# true  -> ǧOK (guest桼ɬOKˤʤ)
	# false -> ǧNG
	#
	def auth( user_info )
		user = user_info.name
		pass = user_info.password

		if user_info.is_guest then
			return true
		end

		book_model = BookModel.new
		book_model.each do |book|
			if user == book.user_name && pass == book.password then
				return true
			end
		end

		return false
	end

	#
	# path, eventʸꤷꤵ줿
	# pathevent򥵡Сž
	#
	def forward_event(req, res, path, event)
		req.path = path
		req.query["event"] = event
		@server.service(req, res)
	end

	#
	# view_pathꤵ줿
	# ե֥饦ˤ֤
	#
	def set_view(req, res, view_path)
		file = open(view_path)
		@erb = ERB.new(file.read)
		res.body = @erb.result(binding)
		res['Content-Type'] = "text/html"
	end

	def do_POST(req, res)
		# Request󤫤桼̾ȥ˥塼֤
		@base_user.set_base_user(req)
		@target_user.set_target_user(req)
		@menu.select(req)
		if req.query["target_date"] == nil then
			today = Date.today
			@target_date = sprintf("%04d%02d%02d", today.year, today.month, today.day)
		else
			@target_date = req.query["target_date"]
		end

		# ǧڼ
		if auth(@base_user) == false then
			@menu.enable_login

			file = open("view/loginfail.rhtml")
			@erb = ERB.new(file.read)
			res.body = @erb.result(binding)
			res['Content-Type'] = "text/html"

		# ǧ
		else
			if @base_user.is_guest then
				@menu.enable_login
			else
				@menu.enable_logout
			end
	
			# ٥̾᥽å̾ȤƸƤӽФ
			event = req.query["event"] 
			if event == nil then
				res.body = "<html>[ERROR][#{self.class.to_s}][#{req.path}] event is not set in HTML FORM.</html>"
			elsif respond_to?  event then
				eval(event + '(req, res)')
			else
				res.body = "<html>[ERROR][#{self.class.to_s}][#{req.path}] [#{req.query["event"]}] is not implemented.</html>"
			end
		end
	end

  
	def do_GET(req, res)
		res.body = "<html>[ERROR][Controller] http method GET is not implemented.</html>"
		res['Content-Type'] = "text/html"
	end
end

