# coding: UTF-8

#=メールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: mail.rb 708 2012-05-20 06:15:27Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail

	attr_reader :subject
	attr_reader :from_address
	attr_reader :to_addresses
	attr_reader :content
	attr_reader :attachments
	attr_reader :html_content
	attr_reader :related_attachments
	attr_accessor :is_report

	def initialize(subject, from_address, to_addresses, content, attachments = [], html_content = nil, related_attachments = [])
		@subject = subject
		@from_address = from_address
		@to_addresses = to_addresses
		@content = content
		@attachments = attachments
		@html_content = html_content
		@related_attachments = related_attachments
		@is_report = false
	end

	def has_content
		return @content != nil
	end

	def has_html_content
		return @html_content != nil
	end

	def escaped_prefix_subject
		if subject =~ /^([rR][eE]|[fF][wW][dD]?) *[:>] *(.+)$/
			return $2
		else
			return subject
		end
	end

end
