<?php
/* ϊO̊G^Cv */
define('MPC_FROM_FOMA'    , 'FOMA');
define('MPC_FROM_EZWEB'   , 'EZWEB');
define('MPC_FROM_SOFTBANK', 'SOFTBANK');
/* ϊO̊Ǧn */
define('MPC_FROM_OPTION_RAW' , 'RAW'); // oCiR[h
define('MPC_FROM_OPTION_WEB' , 'WEB'); // Web̓R[h
define('MPC_FROM_OPTION_IMG' , 'IMG'); // 摜
/* ϊO̕̕R[h */
define('MPC_FROM_CHARSET_SJIS', 'SJIS');
define('MPC_FROM_CHARSET_UTF8', 'UTF-8');
/* ϊ̕̕R[h */
define('MPC_TO_CHARSET_SJIS', 'SJIS');
define('MPC_TO_CHARSET_UTF8', 'UTF-8');

// {{{ class MobilePictogramConverter
/**
* GϊNX
* 
* <pre>
* MobilePictogramConverter  Factory Method NX
*
* MPC_Common      SẴLAɑ΂ċʂ@\x[XNX
* |
* +-MPC_FOMA      FOMAG瑼̊GɕϊۂɃx[XNX
* |               MobilePictogramConverter::factory̑MPC_FROM_FOMAw肵ꍇɌĂяo܂B
* |
* +-MPC_EZweb     EZwebG瑼̊Gɕϊۂ̃x[XNX
* |               MobilePictogramConverter::factory̑MPC_FROM_EZWEBw肵ꍇɌĂяo܂B
* |
* +-MPC_SoftBank  SoftBankG瑼̊Gɕϊۂ̃x[XNX
*                 MobilePictogramConverter::factory̑MPC_FROM_SOFTBANKw肵ꍇɌĂяo܂B
* </pre>
* 
* @author   ryster <ryster@php-develop.org>
* @license  http://www.opensource.org/licenses/mit-license.php The MIT License
* @version  Release: 1.2.0
* @link     http://php-develop.org/MobilePictogramConverter/
*/
class MobilePictogramConverter
{
    /**
    * ^Cvɍ킹āAp̃NXIuWFNg𐶐
    * 
    * .
    * <code>
    * require_once("MobilePictogramConverter.php");
    * 
    * $mpc =& MobilePictogramConverter::factory($str, MPC_FROM_FOMA, MPC_FROM_CHARSET_SJIS);
    * if (is_object($mpc) == false) {
    *     die($mpc);
    * }
    * </code>
    * 
    * @param string  $str     ϊO
    * @param string  $carrier $str̊GLA (MPC_FROM_FOMA, MPC_FROM_EZWEB, MPC_FROM_SOFTBANK)
    * @param string  $charset R[h         (MPC_FROM_CHARSET_SJIS, MPC_FROM_CHARSET_UTF8)
    * @param string  $type    $str̊G^Cv  (MPC_FROM_OPTION_RAW, MPC_FROM_OPTION_WEB, MPC_FROM_OPTION_IMG)
    * @return mixed
    */
    function &factory($str, $carrier, $charset, $type = MPC_FROM_OPTION_RAW)
    {
        $filepath = dirname(__FILE__).'/Carrier/'.strtolower($carrier).'.php';
        if (file_exists($filepath) == false) {
            $error = 'The file doesn\'t exist.';
            return $error;
        }
        
        require_once($filepath);
        $classname = 'MPC_'.$carrier;
        
        if (class_exists($classname) == false) {
            $error = 'The class doesn\'t exist.';
            return $error;
        }
        
        $mpc =& new $classname;
        $mpc->setFromCharset($charset);
        $mpc->setString($str);
        $mpc->setFrom(strtoupper($carrier));
        $mpc->setStringType($type);
        
        return $mpc;
    }
}
// }}}
?>