<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2014 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/blog_mainCommonDef.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/blog_mainDb.php');

class blog_mainBaseWidgetContainer extends BaseWidgetContainer
{
	protected static $_mainDb;			// DB接続オブジェクト
	protected static $_configArray;		// ブログ定義値
	protected static $_paramObj;		// ウィジェットパラメータオブジェクト
	protected static $_canEditEntry;	// 記事が編集可能かどうか
	protected static $_task;			// デフォルトのタスク
	protected $_langId;			// 現在の言語
	protected $_userId;			// 現在のユーザ
	protected $_isMultiLang;			// 多言語対応画面かどうか
	const DEFAULT_COMMENT_LENGTH	= 300;				// デフォルトのコメント最大文字数
	const DEFAULT_CATEGORY_COUNT	= 2;				// デフォルトのカテゴリ数
	
	// 画面
	const TASK_TOP				= 'top';			// トップ画面
	const TASK_ENTRY			= 'entry';			// 記事編集画面
	const TASK_ENTRY_DETAIL 	= 'entry_detail';			// 記事編集画面詳細
	const TASK_COMMENT			= 'comment';		// ブログ記事コメント管理
	const TASK_COMMENT_DETAIL 	= 'comment_detail';		// ブログ記事コメント管理(詳細)
	const TASK_LINKINFO			= 'linkinfo';		// CKEditorプラグインのリンク情報取得用
	const DEFAULT_TASK			= 'top';
	const DEFAULT_CONFIG_TASK	= 'entry';
			
	// アドオンオブジェクト用
	const BLOG_OBJ_ID = 'bloglib';		// ブログオブジェクトID
//	const LINKINFO_OBJ_ID = 'linkinfo';	// リンク情報オブジェクトID
	
	// カレンダー用スクリプト
	const CALENDAR_SCRIPT_FILE = '/jscalendar-1.0/calendar.js';		// カレンダースクリプトファイル
	const CALENDAR_LANG_FILE = '/jscalendar-1.0/lang/calendar-ja.js';	// カレンダー言語ファイル
	const CALENDAR_SETUP_FILE = '/jscalendar-1.0/calendar-setup.js';	// カレンダーセットアップファイル
	const CALENDAR_CSS_FILE = '/jscalendar-1.0/calendar-win2k-1.css';		// カレンダー用CSSファイル
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();

		// DBオブジェクト作成
		if (!isset(self::$_mainDb)) self::$_mainDb = new blog_mainDb();
		
		// ブログ定義を読み込む
		if (!isset(self::$_configArray)) self::$_configArray = blog_mainCommonDef::loadConfig(self::$_mainDb);
		
		$this->_langId = $this->gEnv->getCurrentLanguage();			// 現在の言語
		$this->_userId = $this->gEnv->getCurrentUserId();		// 現在のユーザ
		$this->_isMultiLang = $this->gEnv->isMultiLanguageSite();			// 多言語対応画面かどうか
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _postAssign($request, &$param)
	{
		// ##### 投稿管理画面のトップメニューを作成 #####
		$cmd = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_COMMAND);		// 実行コマンドを取得
		if ($cmd != M3_REQUEST_CMD_DO_WIDGET) return;		// 単体実行以外のときは終了
		
		$openBy = $request->trimValueOf(M3_REQUEST_PARAM_OPEN_BY);		// ウィンドウオープンタイプ
		if ($openBy == 'simple') return;			// シンプルウィンドウのときはメニューを表示しない
		
		// 表示画面を決定
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (empty($task)) $task = self::$_task;
		$blogId = $request->trimValueOf(M3_REQUEST_PARAM_BLOG_ID);		// 所属ブログ
		
		// パンくずリストを作成
		switch ($task){
			case 'entry':		// ブログ記事
			case 'entry_detail':	// ブログ記事詳細
				$linkList = ' &gt;&gt; 記事';// パンくずリスト
				break;
			case 'comment':		// ブログ記事コメント
			case 'comment_detail':	// ブログ記事コメント
				$linkList = ' &gt;&gt; コメント';// パンくずリスト
				break;
		}
		// ベースURL作成
		$urlparam  = M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_DO_WIDGET . '&';
		$urlparam .= M3_REQUEST_PARAM_WIDGET_ID . '=' . $this->gEnv->getCurrentWidgetId() .'&';
		$urlparam .= 'openby=other&' . M3_REQUEST_PARAM_BLOG_ID . '=' . $blogId;
		$baseUrl = $this->gEnv->getDefaultUrl() . '?' . $urlparam;
		
		// ####### 下段メニューの作成 #######		
		$menuText .= '<div id="configmenu-lower">' . M3_NL;
		$menuText .= '<ul>' . M3_NL;

		if ($task == 'entry' ||		// ブログ記事管理
			$task == 'entry_detail' ||
			$task == 'comment' ||		// ブログ記事コメント管理
			$task == 'comment_detail'){
			
			// ブログ記事一覧
			$current = '';
			$link = $baseUrl . '&task=entry';
			//$link = $baseUrl . '&task=entry_detail';		// 詳細をデフォルトにする
			if ($task == 'entry' || $task == 'entry_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $this->getUrl($link) .'"><span>記事</span></a></li>' . M3_NL;
			
			// ブログ記事コメント一覧
			$current = '';
			$link = $baseUrl . '&task=comment';
			if ($task == 'comment' || $task == 'comment_detail') $current = 'id="current"';
			$menuText .= '<li ' . $current . '><a href="'. $this->getUrl($link) .'"><span>コメント</span></a></li>' . M3_NL;
		}
		
		// 下段メニュー終了
		$menuText .= '</ul>' . M3_NL;
		$menuText .= '</div>' . M3_NL;

		// 作成データの埋め込み
		$linkList = '<div id="configmenu-top"><label>' . 'ブログ' . $linkList . '</div>';
		$outputText .= '<table width="90%"><tr><td>' . $linkList . $menuText . '</td></tr></table>' . M3_NL;
		$this->tmpl->addVar("_widget", "menu_items", $outputText);
	}
}
?>
